/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.lifecycle;

import java.util.Set;
import org.eobjects.analyzer.descriptors.ComponentDescriptor;
import org.eobjects.analyzer.descriptors.InitializeMethodDescriptor;
import org.eobjects.analyzer.descriptors.ValidateMethodDescriptor;
import org.eobjects.analyzer.lifecycle.LifeCycleCallback;

final class InitializeCallback
implements LifeCycleCallback<Object, ComponentDescriptor<?>> {
    private final boolean _validate;
    private final boolean _initialize;
    private final boolean _initializeNonDistributed;

    public InitializeCallback(boolean validate, boolean initialize, boolean initializeNonDistributed) {
        this._validate = validate;
        this._initialize = initialize;
        this._initializeNonDistributed = initializeNonDistributed;
    }

    @Override
    public void onEvent(Object component, ComponentDescriptor<?> descriptor) {
        if (this._validate) {
            Set<ValidateMethodDescriptor> validateDescriptors = descriptor.getValidateMethods();
            for (ValidateMethodDescriptor validateDescriptor : validateDescriptors) {
                validateDescriptor.validate(component);
            }
        }
        if (this._initialize) {
            Set<InitializeMethodDescriptor> initializeDescriptors = descriptor.getInitializeMethods();
            for (InitializeMethodDescriptor initializeDescriptor : initializeDescriptors) {
                if (!this._initializeNonDistributed && !initializeDescriptor.isDistributed()) continue;
                initializeDescriptor.initialize(component);
            }
        }
    }
}

