/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.lifecycle;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.eobjects.analyzer.configuration.InjectionPoint;
import org.eobjects.analyzer.lifecycle.AbstractInjectionPoint;

public final class MemberInjectionPoint<T>
extends AbstractInjectionPoint<T>
implements InjectionPoint<T> {
    private final Object _instance;
    private final Member _member;
    private final int _parameterIndex;

    public MemberInjectionPoint(Field field, Object instance) {
        this._instance = instance;
        this._member = field;
        this._parameterIndex = -1;
    }

    public MemberInjectionPoint(Constructor<?> constructor, int parameterIndex) {
        this._instance = null;
        this._member = constructor;
        this._parameterIndex = parameterIndex;
    }

    public MemberInjectionPoint(Method method, int parameterIndex, Object instance) {
        this._instance = instance;
        this._member = method;
        this._parameterIndex = parameterIndex;
    }

    public String toString() {
        return "MemberInjectionPoint [member=" + this._member + ", parameterIndex=" + this._parameterIndex + ", instance=" + this._instance + "]";
    }

    @Override
    public Object getInstance() {
        return this._instance;
    }

    @Override
    public Class<T> getBaseType() {
        if (this._member instanceof Field) {
            return ((Field)this._member).getType();
        }
        if (this._member instanceof Method) {
            return ((Method)this._member).getParameterTypes()[this._parameterIndex];
        }
        if (this._member instanceof Constructor) {
            return ((Constructor)this._member).getParameterTypes()[this._parameterIndex];
        }
        return null;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        if (this._member instanceof Field) {
            return ((Field)this._member).getAnnotation(annotationClass);
        }
        if (this._member instanceof Method) {
            return ((Method)this._member).getAnnotation(annotationClass);
        }
        if (this._member instanceof Constructor) {
            return ((Constructor)this._member).getAnnotation(annotationClass);
        }
        return null;
    }

    @Override
    protected Type getGenericType() {
        if (this._member instanceof Field) {
            return ((Field)this._member).getGenericType();
        }
        if (this._member instanceof Method) {
            return ((Method)this._member).getGenericParameterTypes()[this._parameterIndex];
        }
        if (this._member instanceof Constructor) {
            return ((Constructor)this._member).getGenericParameterTypes()[this._parameterIndex];
        }
        return null;
    }
}

