/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.reference;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Close;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.reference.AbstractReferenceData;
import org.eobjects.analyzer.reference.DatastoreReferenceValues;
import org.eobjects.analyzer.reference.Dictionary;
import org.eobjects.analyzer.reference.ReferenceValues;
import org.eobjects.analyzer.util.ReadObjectBuilder;
import org.eobjects.analyzer.util.SchemaNavigator;
import org.eobjects.metamodel.schema.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatastoreDictionary
extends AbstractReferenceData
implements Dictionary {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DatastoreDictionary.class);
    private transient ReferenceValues<String> _cachedRefValues;
    private transient BlockingQueue<DatastoreConnection> _datastoreConnections = new LinkedBlockingQueue<DatastoreConnection>();
    private final String _datastoreName;
    private final String _qualifiedColumnName;
    @Inject
    @Provided
    transient DatastoreCatalog _datastoreCatalog;

    public DatastoreDictionary(String name, String datastoreName, String qualifiedColumnName) {
        super(name);
        this._datastoreName = datastoreName;
        this._qualifiedColumnName = qualifiedColumnName;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, DatastoreDictionary.class).readObject(stream);
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._datastoreName);
        identifiers.add(this._qualifiedColumnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockingQueue<DatastoreConnection> getDatastoreConnections() {
        if (this._datastoreConnections == null) {
            DatastoreDictionary datastoreDictionary = this;
            synchronized (datastoreDictionary) {
                if (this._datastoreConnections == null) {
                    this._datastoreConnections = new LinkedBlockingQueue<DatastoreConnection>();
                }
            }
        }
        return this._datastoreConnections;
    }

    @Initialize
    public void init() {
        logger.info("Initializing dictionary: {}", (Object)this);
        Datastore datastore = this.getDatastore();
        DatastoreConnection con = datastore.openConnection();
        this.getDatastoreConnections().add(con);
    }

    @Close
    public void close() {
        DatastoreConnection con = (DatastoreConnection)this.getDatastoreConnections().poll();
        if (con != null) {
            logger.info("Closing dictionary: {}", (Object)this);
            con.close();
        }
    }

    private Datastore getDatastore() {
        Datastore datastore = this._datastoreCatalog.getDatastore(this._datastoreName);
        if (datastore == null) {
            throw new IllegalStateException("Could not resolve datastore " + this._datastoreName);
        }
        return datastore;
    }

    public DatastoreCatalog getDatastoreCatalog() {
        return this._datastoreCatalog;
    }

    public String getDatastoreName() {
        return this._datastoreName;
    }

    public String getQualifiedColumnName() {
        return this._qualifiedColumnName;
    }

    @Override
    public boolean containsValue(String value) {
        return this.getValues().containsValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceValues<String> getValues() {
        if (this._cachedRefValues == null) {
            DatastoreDictionary datastoreDictionary = this;
            synchronized (datastoreDictionary) {
                if (this._cachedRefValues == null) {
                    Datastore datastore = this.getDatastore();
                    DatastoreConnection datastoreConnection = datastore.openConnection();
                    SchemaNavigator schemaNavigator = datastoreConnection.getSchemaNavigator();
                    Column column = schemaNavigator.convertToColumns(new String[]{this._qualifiedColumnName})[0];
                    if (column == null) {
                        throw new IllegalStateException("Could not resolve column " + this._qualifiedColumnName);
                    }
                    this._cachedRefValues = new DatastoreReferenceValues(datastore, column);
                    datastoreConnection.close();
                }
            }
        }
        return this._cachedRefValues;
    }
}

