/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.reference.ReferenceValues;
import org.eobjects.analyzer.util.CollectionUtils2;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.builder.SatisfiedWhereBuilder;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.util.BaseObject;

public final class DatastoreReferenceValues
extends BaseObject
implements ReferenceValues<String> {
    private final Datastore _datastore;
    private final Column _column;
    private transient Map<String, Boolean> _containsValueCache = CollectionUtils2.createCacheMap();

    public DatastoreReferenceValues(Datastore datastore, Column column) {
        this._datastore = datastore;
        this._column = column;
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._datastore);
        identifiers.add(this._column);
    }

    public void clearCache() {
        this._containsValueCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(String value) {
        Boolean result = this._containsValueCache.get(value);
        if (result == null) {
            Map<String, Boolean> map = this._containsValueCache;
            synchronized (map) {
                result = this._containsValueCache.get(value);
                if (result == null) {
                    Row row;
                    Query q;
                    result = false;
                    DatastoreConnection con = this._datastore.openConnection();
                    DataContext dataContext = con.getDataContext();
                    DataSet dataSet = dataContext.executeQuery(q = ((SatisfiedWhereBuilder)dataContext.query().from(this._column.getTable()).selectCount().where(this._column).eq(value)).toQuery());
                    if (dataSet.next() && (row = dataSet.getRow()) != null) {
                        Number count = (Number)row.getValue(0);
                        if (count != null && count.intValue() > 0) {
                            result = true;
                        }
                        assert (!dataSet.next());
                    }
                    dataSet.close();
                    con.close();
                    this._containsValueCache.put(value, result);
                }
            }
        }
        return result;
    }

    @Override
    public Collection<String> getValues() {
        DatastoreConnection con = this._datastore.openConnection();
        DataContext dataContext = con.getDataContext();
        Query q = dataContext.query().from(this._column.getTable()).select(this._column).toQuery();
        q.selectDistinct();
        DataSet dataSet = dataContext.executeQuery(q);
        ArrayList<String> values = new ArrayList<String>();
        while (dataSet.next()) {
            Row row = dataSet.getRow();
            Object value = row.getValue(0);
            if (value != null) {
                value = value.toString();
            }
            values.add((String)value);
        }
        dataSet.close();
        con.close();
        return values;
    }
}

