/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.reference;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eobjects.analyzer.reference.AbstractReferenceData;
import org.eobjects.analyzer.reference.StringPattern;
import org.eobjects.analyzer.util.ReadObjectBuilder;

public final class RegexStringPattern
extends AbstractReferenceData
implements StringPattern {
    private static final long serialVersionUID = 1L;
    private final String _expression;
    private final boolean _matchEntireString;
    private transient Pattern _pattern;

    public RegexStringPattern(String name, String expression, boolean matchEntireString) {
        super(name);
        this._expression = expression;
        this._matchEntireString = matchEntireString;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, RegexStringPattern.class).readObject(stream);
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._expression);
        identifiers.add(this._matchEntireString);
    }

    @Override
    public boolean matches(String string) {
        if (string == null) {
            return false;
        }
        Matcher matcher = this.getPattern().matcher(string);
        if (matcher.find()) {
            if (this._matchEntireString) {
                int e;
                int s = matcher.start();
                return s == 0 && (e = matcher.end()) == string.length();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern getPattern() {
        RegexStringPattern regexStringPattern = this;
        synchronized (regexStringPattern) {
            if (this._pattern == null) {
                this._pattern = Pattern.compile(this._expression);
            }
        }
        return this._pattern;
    }

    public boolean isMatchEntireString() {
        return this._matchEntireString;
    }

    public String getExpression() {
        return this._expression;
    }

    @Override
    public String toString() {
        return "RegexStringPattern[name=" + this.getName() + ", expression=" + this._expression + ", matchEntireString=" + this._matchEntireString + "]";
    }
}

