/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.reference;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.reference.AbstractReferenceData;
import org.eobjects.analyzer.reference.Dictionary;
import org.eobjects.analyzer.reference.ReferenceValues;
import org.eobjects.analyzer.reference.SimpleStringReferenceValues;
import org.eobjects.analyzer.util.ReadObjectBuilder;
import org.eobjects.analyzer.util.filemonitor.FileMonitor;
import org.eobjects.analyzer.util.filemonitor.FileMonitorFactory;
import org.eobjects.metamodel.util.FileHelper;

public final class TextFileDictionary
extends AbstractReferenceData
implements Dictionary {
    private static final long serialVersionUID = 1L;
    private transient File _file;
    private transient FileMonitor _fileMonitor;
    private transient Set<String> _entries;
    private final String _filename;
    private final String _encoding;

    public TextFileDictionary(String name, String filename, String encoding) {
        super(name);
        this._filename = filename;
        this._encoding = encoding;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, TextFileDictionary.class).readObject(stream);
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._filename);
        identifiers.add(this._encoding);
    }

    @Override
    public String toString() {
        return "TextFileDictionary[name=" + this.getName() + ", filename=" + this._filename + ", encoding=" + this._encoding + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFile() {
        if (this._file == null) {
            TextFileDictionary textFileDictionary = this;
            synchronized (textFileDictionary) {
                if (this._file == null) {
                    this._file = new File(this._filename);
                }
            }
        }
        return this._file;
    }

    private FileMonitor getFileMonitor() {
        if (this._fileMonitor == null) {
            this._fileMonitor = FileMonitorFactory.getFileMonitor(this.getFile());
        }
        return this._fileMonitor;
    }

    public String getFilename() {
        return this._filename;
    }

    public String getEncoding() {
        return this._encoding;
    }

    @Initialize
    public void init() {
        if (this.getFileMonitor().hasChanged()) {
            this._entries = this.loadEntries();
        }
    }

    public Set<String> getEntries() {
        if (this._entries == null) {
            this._entries = this.loadEntries();
        }
        return this._entries;
    }

    private Set<String> loadEntries() {
        HashSet<String> entries = new HashSet<String>();
        BufferedReader reader = null;
        try {
            reader = FileHelper.getBufferedReader((File)this.getFile(), (String)this._encoding);
            String line = reader.readLine();
            while (line != null) {
                entries.add(line);
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{reader});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{reader});
        return entries;
    }

    @Override
    public boolean containsValue(String value) {
        if (value == null) {
            return false;
        }
        return this.getEntries().contains(value);
    }

    @Override
    public ReferenceValues<String> getValues() {
        return new SimpleStringReferenceValues(this.getEntries(), true);
    }
}

