/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.reference;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eobjects.analyzer.reference.AbstractReferenceData;
import org.eobjects.analyzer.reference.Synonym;
import org.eobjects.analyzer.reference.SynonymCatalog;
import org.eobjects.analyzer.reference.TextFileSynonym;
import org.eobjects.analyzer.util.CollectionUtils2;
import org.eobjects.analyzer.util.ReadObjectBuilder;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.analyzer.util.filemonitor.FileMonitor;
import org.eobjects.analyzer.util.filemonitor.FileMonitorFactory;
import org.eobjects.metamodel.util.FileHelper;

public final class TextFileSynonymCatalog
extends AbstractReferenceData
implements SynonymCatalog {
    private static final long serialVersionUID = 1L;
    private volatile transient Map<String, String> _masterTermCache;
    private transient File _file;
    private transient FileMonitor _fileMonitor;
    private final String _filename;
    private final boolean _caseSensitive;
    private final String _encoding;

    public TextFileSynonymCatalog(String name, String filename, boolean caseSensitive, String encoding) {
        super(name);
        this._filename = filename;
        this._caseSensitive = caseSensitive;
        this._encoding = encoding;
    }

    public TextFileSynonymCatalog(String name, File file, boolean caseSensitive, String encoding) {
        super(name);
        this._filename = file.getPath();
        this._caseSensitive = caseSensitive;
        this._encoding = encoding;
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._filename);
        identifiers.add(this._caseSensitive);
        identifiers.add(this._encoding);
    }

    @Override
    public String toString() {
        return "TextFileSynonymCatalog[name=" + this.getName() + ", filename=" + this._filename + ", caseSensitive=" + this._caseSensitive + ", encoding=" + this._encoding + "]";
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, TextFileSynonymCatalog.class).readObject(stream);
    }

    public String getEncoding() {
        return this._encoding;
    }

    public String getFilename() {
        return this._filename;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFile() {
        if (this._file == null) {
            TextFileSynonymCatalog textFileSynonymCatalog = this;
            synchronized (textFileSynonymCatalog) {
                if (this._file == null) {
                    this._file = new File(this._filename);
                }
            }
        }
        return this._file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileMonitor getFileMonitor() {
        if (this._fileMonitor == null) {
            TextFileSynonymCatalog textFileSynonymCatalog = this;
            synchronized (textFileSynonymCatalog) {
                if (this._fileMonitor == null) {
                    this._fileMonitor = FileMonitorFactory.getFileMonitor(this.getFile());
                }
            }
        }
        return this._fileMonitor;
    }

    public Collection<Synonym> getSynonyms() {
        ArrayList<Synonym> arrayList;
        BufferedReader reader = FileHelper.getBufferedReader((File)this.getFile(), (String)this._encoding);
        try {
            ArrayList<Synonym> synonyms = new ArrayList<Synonym>();
            String line = reader.readLine();
            while (line != null) {
                line = line.trim();
                synonyms.add(new TextFileSynonym(line, this._caseSensitive));
                line = reader.readLine();
            }
            arrayList = synonyms;
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{reader});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{reader});
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getMasterTermCache() {
        if (this._masterTermCache == null) {
            TextFileSynonymCatalog textFileSynonymCatalog = this;
            synchronized (textFileSynonymCatalog) {
                if (this._masterTermCache == null) {
                    this._masterTermCache = CollectionUtils2.createCacheMap();
                }
            }
        } else if (this.getFileMonitor().hasChanged()) {
            this._masterTermCache = CollectionUtils2.createCacheMap();
        }
        return this._masterTermCache;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getMasterTerm(String term) {
        String string;
        BufferedReader reader;
        block9: {
            String line;
            if (StringUtils.isNullOrEmpty(term)) {
                return null;
            }
            String masterTerm = this.getMasterTermCache().get(term);
            if (masterTerm != null) {
                return masterTerm;
            }
            reader = FileHelper.getBufferedReader((File)this.getFile(), (String)this._encoding);
            try {
                line = reader.readLine();
                while (line != null) {
                    TextFileSynonym synonym = new TextFileSynonym(line = line.trim(), this._caseSensitive);
                    masterTerm = synonym.getMasterTerm();
                    if (term.equals(masterTerm) || synonym.getSynonyms().containsValue(term)) {
                        this.getMasterTermCache().put(term, masterTerm);
                        string = masterTerm;
                        break block9;
                    }
                    line = reader.readLine();
                }
                line = null;
            }
            catch (IOException e) {
                try {
                    throw new IllegalStateException(e);
                }
                catch (Throwable throwable) {
                    FileHelper.safeClose((Object[])new Object[]{reader});
                    throw throwable;
                }
            }
            FileHelper.safeClose((Object[])new Object[]{reader});
            return line;
        }
        FileHelper.safeClose((Object[])new Object[]{reader});
        return string;
    }
}

