/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.result;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.result.AnalyzerResultReducer;
import org.eobjects.analyzer.result.AnnotatedRowsResult;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabDimension;
import org.eobjects.analyzer.result.CrosstabNavigator;
import org.eobjects.analyzer.result.CrosstabResult;
import org.eobjects.analyzer.result.ResultProducer;
import org.eobjects.metamodel.util.NumberComparator;

public abstract class AbstractCrosstabResultReducer<R extends CrosstabResult>
implements AnalyzerResultReducer<R> {
    public R reduce(Collection<? extends R> results) {
        Crosstab<Serializable> masterCrosstab = this.createMasterCrosstab(results);
        Class<Serializable> valueClass = masterCrosstab.getValueClass();
        CrosstabDimension dimension1 = masterCrosstab.getDimension(0);
        CrosstabDimension dimension2 = masterCrosstab.getDimension(1);
        CrosstabNavigator<Serializable> masterNav = masterCrosstab.navigate();
        for (String category1 : dimension1) {
            masterNav.where(dimension1.getName(), category1);
            for (String category2 : dimension2) {
                ResultProducer masterResultProducer;
                masterNav.where(dimension2.getName(), category2);
                String[] categories = new String[]{category1, category2};
                ArrayList<ResultProducer> slaveResultProducers = new ArrayList<ResultProducer>();
                ArrayList<Object> slaveValues = new ArrayList<Object>(results.size());
                for (CrosstabResult result : results) {
                    Crosstab<?> slaveCrosstab = result.getCrosstab();
                    try {
                        Object slaveValue = slaveCrosstab.getValue(categories);
                        slaveValues.add(slaveValue);
                        ResultProducer resultProducer = slaveCrosstab.explore(categories);
                        if (resultProducer == null) continue;
                        slaveResultProducers.add(resultProducer);
                    }
                    catch (IllegalArgumentException e) {}
                }
                Serializable masterValue = this.reduceValues(slaveValues, category1, category2, results, valueClass);
                masterNav.put(masterValue);
                if (slaveResultProducers.isEmpty() || (masterResultProducer = this.reduceResultProducers(slaveResultProducers, category1, category2, valueClass, masterValue)) == null) continue;
                masterNav.attach(masterResultProducer);
            }
        }
        return this.buildResult(masterCrosstab, results);
    }

    protected Crosstab<Serializable> createMasterCrosstab(Collection<? extends R> results) {
        CrosstabResult firstResult = (CrosstabResult)results.iterator().next();
        Crosstab<?> firstCrosstab = firstResult.getCrosstab();
        Class<?> valueClass = firstCrosstab.getValueClass();
        CrosstabDimension dimension1 = firstCrosstab.getDimension(0);
        CrosstabDimension dimension2 = firstCrosstab.getDimension(1);
        Crosstab<Serializable> masterCrosstab = new Crosstab<Serializable>(valueClass, dimension1, dimension2);
        return masterCrosstab;
    }

    protected ResultProducer reduceResultProducers(List<ResultProducer> slaveResultProducers, String category1, String category2, Class<?> valueClass, Serializable masterValue) {
        for (ResultProducer resultProducer : slaveResultProducers) {
            AnalyzerResult result = resultProducer.getResult();
            if (!(result instanceof AnnotatedRowsResult) || ((AnnotatedRowsResult)result).getAnnotatedRowCount() <= 0) continue;
            return resultProducer;
        }
        return null;
    }

    protected abstract Serializable reduceValues(List<Object> var1, String var2, String var3, Collection<? extends R> var4, Class<?> var5);

    protected abstract R buildResult(Crosstab<?> var1, Collection<? extends R> var2);

    protected static Number sum(List<?> slaveValues) {
        for (Object slaveValue : slaveValues) {
            Class<?> cls;
            if (slaveValue == null || (cls = slaveValue.getClass()) == Integer.class || cls == Short.class || cls == Byte.class) continue;
            return AbstractCrosstabResultReducer.sumAsDouble(slaveValues);
        }
        return AbstractCrosstabResultReducer.sumAsInteger(slaveValues);
    }

    protected static Integer sumAsInteger(List<?> slaveValues) {
        int sum = 0;
        for (Object slaveValue : slaveValues) {
            Number value = (Number)slaveValue;
            if (value == null) continue;
            sum += value.intValue();
        }
        return sum;
    }

    protected static Double sumAsDouble(List<?> slaveValues) {
        double sum = 0.0;
        for (Object slaveValue : slaveValues) {
            Number value = (Number)slaveValue;
            if (value == null) continue;
            sum += value.doubleValue();
        }
        return sum;
    }

    protected static Number maximum(List<?> slaveValues) {
        Number max = null;
        for (Object slaveValue : slaveValues) {
            if (max == null) {
                max = (Number)slaveValue;
                continue;
            }
            Comparable comparable = NumberComparator.getComparable(max);
            if (comparable.compareTo(slaveValue) >= 0) continue;
            max = (Number)slaveValue;
        }
        return max;
    }

    protected static Number minimum(List<?> slaveValues) {
        Number min = null;
        for (Object slaveValue : slaveValues) {
            if (min == null) {
                min = (Number)slaveValue;
                continue;
            }
            Comparable comparable = NumberComparator.getComparable(min);
            if (comparable.compareTo(slaveValue) <= 0) continue;
            min = (Number)slaveValue;
        }
        return min;
    }
}

