/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.result.TableModelResult;
import org.eobjects.analyzer.storage.InMemoryRowAnnotationFactory;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;
import org.eobjects.metamodel.util.Ref;
import org.eobjects.metamodel.util.SerializableRef;

public class AnnotatedRowsResult
implements AnalyzerResult,
TableModelResult {
    private static final long serialVersionUID = 1L;
    private final Ref<RowAnnotationFactory> _annotationFactoryRef;
    private final InputColumn<?>[] _highlightedColumns;
    private final RowAnnotation _annotation;
    private transient InputRow[] _rows;
    private transient TableModel _tableModel;
    private transient List<InputColumn<?>> _inputColumns;

    public AnnotatedRowsResult(RowAnnotation annotation, RowAnnotationFactory annotationFactory, InputColumn<?> ... highlightedColumns) {
        this._annotationFactoryRef = new SerializableRef((Object)annotationFactory);
        this._annotation = annotation;
        this._highlightedColumns = highlightedColumns;
    }

    public List<InputColumn<?>> getInputColumns() {
        if (this._inputColumns == null) {
            InputRow[] rows = this.getRows();
            if (rows.length > 0) {
                InputRow firstRow = rows[0];
                this._inputColumns = firstRow.getInputColumns();
            } else {
                this._inputColumns = new ArrayList(0);
            }
        }
        return this._inputColumns;
    }

    public InputRow[] getRows() {
        if (this._rows == null) {
            RowAnnotationFactory annotationFactory = (RowAnnotationFactory)this._annotationFactoryRef.get();
            if (annotationFactory != null) {
                this._rows = annotationFactory.getRows(this.getAnnotation());
            }
            if (this._rows == null) {
                this._rows = new InputRow[0];
            }
        }
        return this._rows;
    }

    public TableModel toDistinctValuesTableModel(InputColumn<?> inputColumnOfInterest) {
        RowAnnotationFactory annotationFactory = (RowAnnotationFactory)this._annotationFactoryRef.get();
        Map<Object, Object> valueCounts = annotationFactory == null ? Collections.emptyMap() : annotationFactory.getValueCounts(this.getAnnotation(), inputColumnOfInterest);
        DefaultTableModel tableModel = new DefaultTableModel(new String[]{inputColumnOfInterest.getName(), "Count in dataset"}, valueCounts.size());
        TreeSet<Map.Entry<Object, Integer>> set = new TreeSet<Map.Entry<Object, Integer>>(new Comparator<Map.Entry<Object, Integer>>(){

            @Override
            public int compare(Map.Entry<Object, Integer> o1, Map.Entry<Object, Integer> o2) {
                int countDiff = o2.getValue() - o1.getValue();
                if (countDiff == 0) {
                    return -1;
                }
                return countDiff;
            }
        });
        set.addAll(valueCounts.entrySet());
        int i = 0;
        for (Map.Entry<Object, Integer> entry : set) {
            tableModel.setValueAt(entry.getKey(), i, 0);
            tableModel.setValueAt(entry.getValue(), i, 1);
            ++i;
        }
        return tableModel;
    }

    public TableModel toTableModel(int maxRows) {
        if (maxRows < 0) {
            maxRows = Integer.MAX_VALUE;
        }
        InputRow[] rows = this.getRows();
        List<InputColumn<?>> inputColumns = this.getInputColumns();
        Object[] headers = new String[inputColumns.size()];
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = inputColumns.get(i).getName();
        }
        int actualRows = Math.min(maxRows, rows.length);
        DefaultTableModel tableModel = new DefaultTableModel(headers, actualRows);
        int row = 0;
        for (InputRow inputRow : rows) {
            if (actualRows == row) break;
            for (int i = 0; i < inputColumns.size(); ++i) {
                InputColumn<?> inputColumn = inputColumns.get(i);
                Object value = inputRow.getValue(inputColumn);
                tableModel.setValueAt(value, row, i);
            }
            ++row;
        }
        return tableModel;
    }

    @Override
    public TableModel toTableModel() {
        if (this._tableModel == null) {
            this._tableModel = this.toTableModel(-1);
        }
        return this._tableModel;
    }

    public InputColumn<?>[] getHighlightedColumns() {
        return this._highlightedColumns;
    }

    public int getColumnIndex(InputColumn<?> col) {
        List<InputColumn<?>> inputColumns = this.getInputColumns();
        int i = 0;
        for (InputColumn<?> inputColumn : inputColumns) {
            if (col.equals(inputColumn)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public RowAnnotation getAnnotation() {
        if (this._annotation == null) {
            return new InMemoryRowAnnotationFactory().createAnnotation();
        }
        return this._annotation;
    }

    public int getAnnotatedRowCount() {
        return this.getAnnotation().getRowCount();
    }
}

