/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.result;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eobjects.analyzer.result.CrosstabDimension;
import org.eobjects.analyzer.result.CrosstabNavigator;
import org.eobjects.analyzer.result.ResultProducer;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.metamodel.util.Ref;
import org.eobjects.metamodel.util.SerializableRef;

public final class Crosstab<E extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<CrosstabDimension> dimensions;
    private final Map<String, E> values = new HashMap<String, E>();
    private final Class<E> valueClass;
    private final Map<String, Ref<ResultProducer>> resultProducers = new HashMap<String, Ref<ResultProducer>>();

    public Crosstab(Class<E> valueClass, CrosstabDimension ... dimensions) {
        this.valueClass = valueClass;
        this.dimensions = Arrays.asList(dimensions);
    }

    public Crosstab(Class<E> valueClass, Collection<CrosstabDimension> dimensions) {
        this.valueClass = valueClass;
        this.dimensions = new ArrayList<CrosstabDimension>(dimensions);
    }

    public Crosstab(Class<E> valueClass, String ... dimensionNames) {
        this.valueClass = valueClass;
        this.dimensions = new ArrayList<CrosstabDimension>();
        for (String name : dimensionNames) {
            this.dimensions.add(new CrosstabDimension(name));
        }
    }

    public Class<E> getValueClass() {
        return this.valueClass;
    }

    public <T extends Serializable> Crosstab<T> castValueClass(Class<T> valueClass) {
        if (ReflectionUtils.is(this.valueClass, valueClass)) {
            return this;
        }
        throw new IllegalArgumentException("Unable to cast [" + this.valueClass + "] to [" + valueClass + "]");
    }

    public List<CrosstabDimension> getDimensions() {
        return Collections.unmodifiableList(this.dimensions);
    }

    private String getKey(String[] categories) throws IllegalArgumentException, NullPointerException {
        if (categories.length != this.dimensions.size()) {
            throw new IllegalArgumentException("Not all dimensions have been specified (differences in size of parameter and Crosstab's dimensions)");
        }
        for (int i = 0; i < categories.length; ++i) {
            if (categories[i] != null) continue;
            CrosstabDimension dimension = this.dimensions.get(i);
            throw new NullPointerException("Not all dimensions have been specified ('" + dimension.getName() + "' is null)");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < categories.length; ++i) {
            String category;
            CrosstabDimension dimension = this.dimensions.get(i);
            if (!dimension.containsCategory(category = categories[i])) {
                throw new IllegalArgumentException("Unknown category [" + category + "] for dimension [" + dimension.getName() + "]");
            }
            if (i != 0) {
                sb.append('^');
            }
            sb.append(category);
        }
        return sb.toString();
    }

    public CrosstabNavigator<E> navigate() {
        return new CrosstabNavigator(this);
    }

    protected E getValue(String[] categories) throws IllegalArgumentException, NullPointerException {
        String key = this.getKey(categories);
        return (E)((Serializable)this.values.get(key));
    }

    public CrosstabNavigator<E> where(String dimension, String isCategory) {
        return this.navigate().where(dimension, isCategory);
    }

    public CrosstabNavigator<E> where(CrosstabDimension dimension, String isCategory) {
        return this.navigate().where(dimension, isCategory);
    }

    protected void putValue(E value, String[] categories) throws IllegalArgumentException, NullPointerException {
        if (value != null && !ReflectionUtils.is(value.getClass(), this.valueClass)) {
            throw new IllegalArgumentException("Cannot put value [" + value + "] of type [" + value.getClass() + "] when Crosstab.valueClass is [" + this.valueClass + "]");
        }
        String key = this.getKey(categories);
        this.values.put(key, value);
    }

    public int getDimensionCount() {
        return this.dimensions.size();
    }

    public String[] getDimensionNames() {
        int size = this.dimensions.size();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.dimensions.get(i).getName();
        }
        return result;
    }

    public int getDimensionIndex(CrosstabDimension dimension) {
        if (dimension != null) {
            int size = this.dimensions.size();
            for (int i = 0; i < size; ++i) {
                if (!dimension.equals(this.dimensions.get(i))) continue;
                return i;
            }
        }
        throw new IllegalArgumentException("No such dimension: " + dimension);
    }

    public int getDimensionIndex(String dimensionName) {
        if (dimensionName != null) {
            int size = this.dimensions.size();
            for (int i = 0; i < size; ++i) {
                if (!dimensionName.equals(this.dimensions.get(i).getName())) continue;
                return i;
            }
        }
        throw new IllegalArgumentException("No such dimension: " + dimensionName);
    }

    public CrosstabDimension getDimension(int i) {
        return this.dimensions.get(i);
    }

    public CrosstabDimension getDimension(String dimensionName) {
        return this.getDimension(this.getDimensionIndex(dimensionName));
    }

    protected void attachResultProducer(ResultProducer resultProducer, String[] categories) throws IllegalArgumentException, NullPointerException {
        String key = this.getKey(categories);
        if (resultProducer == null) {
            this.resultProducers.remove(key);
        } else {
            SerializableRef resultProducerRef = new SerializableRef((Object)resultProducer);
            this.resultProducers.put(key, (Ref<ResultProducer>)resultProducerRef);
        }
    }

    protected ResultProducer explore(String[] categories) {
        String key = this.getKey(categories);
        Ref<ResultProducer> resultProducerRef = this.resultProducers.get(key);
        if (resultProducerRef == null) {
            return null;
        }
        return (ResultProducer)resultProducerRef.get();
    }

    public String toString() {
        return this.toString(8);
    }

    public String toString(int maxEntries) {
        StringBuilder sb = new StringBuilder("Crosstab:");
        TreeSet<String> keySet = new TreeSet<String>(this.values.keySet());
        for (String key : keySet) {
            if (maxEntries == 0) break;
            sb.append('\n');
            sb.append(key.replaceAll("\\^", ","));
            sb.append(": ");
            Serializable value = (Serializable)this.values.get(key);
            sb.append(value);
            --maxEntries;
        }
        return sb.toString();
    }
}

