/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.result;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CrosstabDimension
implements Serializable,
Iterable<String> {
    private static final long serialVersionUID = 1L;
    private List<String> categories = new ArrayList<String>();
    private String name;

    public CrosstabDimension(String name) {
        if (name.contains("|")) {
            throw new IllegalArgumentException("Dimensions cannot contain the character '^'");
        }
        this.name = name;
    }

    public void addCategories(Collection<String> categories) {
        for (String category : categories) {
            this.addCategory(category);
        }
    }

    public CrosstabDimension addCategory(String category) {
        if (!this.categories.contains(category)) {
            this.categories.add(category);
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public boolean containsCategory(String category) {
        return this.categories.contains(category);
    }

    public List<String> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    @Override
    public Iterator<String> iterator() {
        return this.getCategories().iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.categories == null ? 0 : ((Object)this.categories).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CrosstabDimension other = (CrosstabDimension)obj;
        if (this.categories == null ? other.categories != null : !((Object)this.categories).equals(other.categories)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int getCategoryCount() {
        return this.categories.size();
    }

    public String toString() {
        return "CrosstabDimension[name=" + this.name + ", categories=" + this.categories + "]";
    }
}

