/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.result;

import java.io.Serializable;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabDimension;
import org.eobjects.analyzer.result.DefaultResultProducer;
import org.eobjects.analyzer.result.ResultProducer;

public class CrosstabNavigator<E extends Serializable>
implements Cloneable {
    private Crosstab<E> crosstab;
    private String[] categories;

    public CrosstabNavigator(Crosstab<E> crosstab) {
        this.crosstab = crosstab;
        this.categories = new String[crosstab.getDimensionCount()];
    }

    public CrosstabNavigator<E> where(String dimension, String isCategory) {
        int index = this.crosstab.getDimensionIndex(dimension);
        this.categories[index] = isCategory;
        return this;
    }

    public CrosstabNavigator<E> where(CrosstabDimension dimension, String isCategory) {
        return this.where(dimension.getName(), isCategory);
    }

    public void put(E value) throws IllegalArgumentException, NullPointerException {
        this.put(value, false);
    }

    public void put(E value, boolean createCategories) throws IllegalArgumentException, NullPointerException {
        if (createCategories) {
            for (int i = 0; i < this.categories.length; ++i) {
                String category = this.categories[i];
                CrosstabDimension dimension = this.crosstab.getDimension(i);
                dimension.addCategory(category);
            }
        }
        this.crosstab.putValue(value, this.categories);
    }

    public E get() throws IllegalArgumentException, NullPointerException {
        return this.crosstab.getValue(this.categories);
    }

    public E safeGet(E valueIfError) {
        try {
            return this.get();
        }
        catch (Exception e) {
            return valueIfError;
        }
    }

    public void attach(AnalyzerResult explorationResult) {
        this.attach(new DefaultResultProducer(explorationResult));
    }

    public void attach(ResultProducer explorationResultProducer) {
        this.crosstab.attachResultProducer(explorationResultProducer, this.categories);
    }

    public ResultProducer explore() {
        return this.crosstab.explore(this.categories);
    }

    public CrosstabNavigator<E> clone() {
        try {
            CrosstabNavigator n = (CrosstabNavigator)super.clone();
            n.categories = (String[])this.categories.clone();
            return n;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getCategory(CrosstabDimension dimension) {
        int index = this.crosstab.getDimensionIndex(dimension);
        return this.categories[index];
    }
}

