/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.result;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eobjects.analyzer.beans.api.ParameterizableMetric;
import org.eobjects.analyzer.util.convert.StringConverter;

public abstract class QueryParameterizableMetric
implements ParameterizableMetric {
    private final Pattern _pattern = Pattern.compile("(NOT )?IN (\\[.+\\])", 2);

    public final Number getValue(String parameter) {
        String trimmedParameter = parameter.trim();
        Matcher matcher = this._pattern.matcher(trimmedParameter);
        if (matcher.matches()) {
            String group = matcher.group(2);
            StringConverter conv = new StringConverter(null);
            String[] values = conv.deserialize(group, String[].class);
            int sum = 0;
            for (String value : values) {
                sum += this.getInstanceCount(value);
            }
            if (trimmedParameter.toUpperCase().startsWith("NOT IN")) {
                return this.getTotalCount() - sum;
            }
            return sum;
        }
        Integer count = this.getInstanceCount(parameter);
        if (count == null) {
            return 0;
        }
        return count;
    }

    protected abstract int getTotalCount();

    protected abstract int getInstanceCount(String var1);
}

