/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.result.renderer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabDimension;
import org.eobjects.analyzer.result.CrosstabNavigator;
import org.eobjects.analyzer.result.ResultProducer;
import org.eobjects.analyzer.result.renderer.CrosstabRendererCallback;
import org.eobjects.metamodel.util.CollectionUtils;

public class CrosstabRenderer {
    private static final int MAX_HORIZONTAL_CELLS = 10;
    private final Crosstab<?> crosstab;
    private final List<CrosstabDimension> horizontalDimensions;
    private final List<CrosstabDimension> verticalDimensions;
    private int horizontalCells = 1;
    private int verticalCells = 1;

    public CrosstabRenderer(Crosstab<?> crosstab) {
        if (crosstab == null) {
            throw new IllegalArgumentException("Crosstab cannot be null");
        }
        this.crosstab = crosstab;
        this.horizontalDimensions = new ArrayList<CrosstabDimension>();
        this.verticalDimensions = new ArrayList<CrosstabDimension>();
    }

    public void autoAssignDimensions() {
        List<CrosstabDimension> dimensions = this.crosstab.getDimensions();
        LinkedList<CrosstabDimension> autoAssignDimensions = new LinkedList<CrosstabDimension>();
        for (CrosstabDimension dimension : dimensions) {
            if (this.isAssigned(dimension)) continue;
            autoAssignDimensions.add(dimension);
        }
        if (autoAssignDimensions.size() == 2) {
            this.makeHorizontal((CrosstabDimension)autoAssignDimensions.get(0));
            this.makeVertical((CrosstabDimension)autoAssignDimensions.get(1));
        } else {
            for (CrosstabDimension dimension : autoAssignDimensions) {
                boolean horizontal = false;
                int categoryCount = dimension.getCategoryCount();
                if (this.horizontalCells <= 10 && categoryCount <= 10 && this.horizontalCells * categoryCount <= 10) {
                    this.makeHorizontal(dimension);
                    horizontal = true;
                }
                if (horizontal) continue;
                this.makeVertical(dimension);
            }
        }
    }

    public boolean isAssigned(CrosstabDimension dimension) {
        return this.verticalDimensions.contains(dimension) || this.horizontalDimensions.contains(dimension);
    }

    public void makeHorizontal(CrosstabDimension dimension) {
        if (this.verticalDimensions.contains(dimension)) {
            this.verticalDimensions.remove(dimension);
            this.verticalCells /= dimension.getCategoryCount();
        }
        if (!this.horizontalDimensions.contains(dimension)) {
            this.horizontalDimensions.add(dimension);
            this.horizontalCells *= dimension.getCategoryCount();
        }
    }

    public void makeVertical(CrosstabDimension dimension) {
        if (this.horizontalDimensions.contains(dimension)) {
            this.horizontalDimensions.remove(dimension);
            this.horizontalCells /= dimension.getCategoryCount();
        }
        if (!this.verticalDimensions.contains(dimension)) {
            this.verticalDimensions.add(dimension);
            this.verticalCells *= dimension.getCategoryCount();
        }
    }

    public <E> E render(CrosstabRendererCallback<E> callback) {
        this.autoAssignDimensions();
        List<CrosstabDimension> dimensions = this.crosstab.getDimensions();
        if (CollectionUtils.isNullOrEmpty(dimensions)) {
            return callback.getResult();
        }
        if (CollectionUtils.isNullOrEmpty(this.horizontalDimensions) && CollectionUtils.isNullOrEmpty(this.verticalDimensions)) {
            return callback.getResult();
        }
        callback.beginTable(this.crosstab, this.horizontalDimensions, this.verticalDimensions);
        int colspan = this.horizontalCells;
        int repeatHeaders = 1;
        for (int i = 0; i < this.horizontalDimensions.size(); ++i) {
            CrosstabDimension dimension = this.horizontalDimensions.get(i);
            if (dimension.getCategoryCount() <= 0) continue;
            callback.beginRow();
            for (CrosstabDimension verticalDimension : this.verticalDimensions) {
                callback.emptyHeader(verticalDimension, dimension);
            }
            colspan /= dimension.getCategoryCount();
            for (int j = 0; j < repeatHeaders; ++j) {
                for (String category : dimension.getCategories()) {
                    callback.horizontalHeaderCell(category, dimension, colspan);
                }
            }
            repeatHeaders *= dimension.getCategoryCount();
            callback.endRow();
        }
        CrosstabNavigator<?> navigator = this.crosstab.navigate();
        for (int i = 0; i < this.verticalCells; ++i) {
            callback.beginRow();
            this.navigateOnAxis(this.verticalDimensions, i, this.verticalCells, navigator);
            int rowspan = this.verticalCells;
            for (int j = 0; j < this.verticalDimensions.size(); ++j) {
                CrosstabDimension dimension = this.verticalDimensions.get(j);
                if (i % (rowspan /= dimension.getCategoryCount()) != 0) continue;
                String category = navigator.getCategory(dimension);
                callback.verticalHeaderCell(category, dimension, rowspan);
            }
            for (int j = 0; j < this.horizontalCells; ++j) {
                this.navigateOnAxis(this.horizontalDimensions, j, this.horizontalCells, navigator);
                Object value = navigator.get();
                ResultProducer resultProducer = navigator.explore();
                callback.valueCell(value, resultProducer);
            }
            callback.endRow();
        }
        callback.endTable();
        return callback.getResult();
    }

    private void navigateOnAxis(List<CrosstabDimension> dimensionsOnAxis, int cellIndex, int cellCount, CrosstabNavigator<?> navigator) {
        int colspan = cellCount;
        int category = 0;
        int localIndex = cellIndex;
        for (int k = 0; k < dimensionsOnAxis.size(); ++k) {
            CrosstabDimension dimension = dimensionsOnAxis.get(k);
            int categoryCount = dimension.getCategoryCount();
            int offset = category * colspan;
            category = (localIndex -= offset) / (colspan /= categoryCount);
            String categoryName = dimension.getCategories().get(category);
            navigator.where(dimension, categoryName);
        }
    }
}

