/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.result.renderer;

import java.text.NumberFormat;
import java.util.List;
import org.eobjects.analyzer.beans.api.RendererBean;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabDimension;
import org.eobjects.analyzer.result.CrosstabResult;
import org.eobjects.analyzer.result.ResultProducer;
import org.eobjects.analyzer.result.renderer.AbstractRenderer;
import org.eobjects.analyzer.result.renderer.CrosstabRenderer;
import org.eobjects.analyzer.result.renderer.CrosstabRendererCallback;
import org.eobjects.analyzer.result.renderer.TextRenderingFormat;
import org.eobjects.analyzer.util.LabelUtils;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.metamodel.util.FormatHelper;

@RendererBean(value=TextRenderingFormat.class)
public class CrosstabTextRenderer
extends AbstractRenderer<CrosstabResult, String> {
    public String render(CrosstabResult result) {
        return this.render(result.getCrosstab());
    }

    public String render(Crosstab<?> crosstab) {
        return new CrosstabRenderer(crosstab).render(new TextCrosstabRendererCallback());
    }

    private static class TextCrosstabRendererCallback
    implements CrosstabRendererCallback<String> {
        private NumberFormat decimalFormat = FormatHelper.getUiNumberFormat();
        private boolean leftAligned;
        private StringBuilder sb;
        private int horizontalDimensionWidth;

        private TextCrosstabRendererCallback() {
        }

        @Override
        public void beginTable(Crosstab<?> crosstab, List<CrosstabDimension> horizontalDimensions, List<CrosstabDimension> verticalDimensions) {
            this.sb = new StringBuilder();
            this.horizontalDimensionWidth = 0;
            for (CrosstabDimension dimension : horizontalDimensions) {
                List<String> categories = dimension.getCategories();
                for (String category : categories) {
                    this.horizontalDimensionWidth = Math.max(this.horizontalDimensionWidth, category.length());
                }
            }
            this.horizontalDimensionWidth = Math.max(this.horizontalDimensionWidth, 6);
            this.leftAligned = !ReflectionUtils.is(crosstab.getValueClass(), Number.class);
        }

        @Override
        public void endTable() {
        }

        @Override
        public void beginRow() {
        }

        @Override
        public void endRow() {
            this.sb.append('\n');
        }

        @Override
        public void horizontalHeaderCell(String category, CrosstabDimension dimension, int width) {
            int trailingBlanks = this.horizontalDimensionWidth * width - category.length();
            if (this.leftAligned) {
                this.sb.append(category);
                for (int i = 0; i < trailingBlanks; ++i) {
                    this.sb.append(' ');
                }
            } else {
                for (int i = 0; i < trailingBlanks; ++i) {
                    this.sb.append(' ');
                }
                this.sb.append(category);
            }
            this.sb.append(' ');
        }

        @Override
        public void verticalHeaderCell(String category, CrosstabDimension dimension, int height) {
            this.sb.append(category);
            int dimensionWidth = this.getWidth(dimension);
            dimensionWidth -= category.length();
            for (int i = 0; i < dimensionWidth; ++i) {
                this.sb.append(' ');
            }
            this.sb.append(' ');
        }

        @Override
        public void valueCell(Object value, ResultProducer drillToDetailResultProducer) {
            boolean leftAligned = this.leftAligned;
            String stringValue = value == null ? null : value.toString();
            stringValue = LabelUtils.getValueLabel(stringValue);
            if (value instanceof Number) {
                leftAligned = false;
                if (value instanceof Double || value instanceof Float) {
                    stringValue = this.decimalFormat.format(value);
                }
            }
            int trailingBlanks = this.horizontalDimensionWidth - stringValue.length();
            if (leftAligned) {
                this.sb.append(stringValue);
                for (int i = 0; i < trailingBlanks; ++i) {
                    this.sb.append(' ');
                }
            } else {
                for (int i = 0; i < trailingBlanks; ++i) {
                    this.sb.append(' ');
                }
                this.sb.append(stringValue);
            }
            this.sb.append(' ');
        }

        @Override
        public void emptyHeader(CrosstabDimension verticalDimension, CrosstabDimension horizontalDimension) {
            int dimensionWidth = this.getWidth(verticalDimension);
            for (int i = 0; i < dimensionWidth; ++i) {
                this.sb.append(' ');
            }
            this.sb.append(' ');
        }

        private int getWidth(CrosstabDimension verticalDimension) {
            List<String> categories = verticalDimension.getCategories();
            int longestCategory = 0;
            for (String category : categories) {
                longestCategory = Math.max(longestCategory, category.length());
            }
            return longestCategory;
        }

        @Override
        public String getResult() {
            if (this.sb == null) {
                return "";
            }
            return this.sb.toString();
        }
    }
}

