/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.util;

public class AverageBuilder {
    private double _average = 0.0;
    private int _numValues = 0;

    public AverageBuilder addValue(Number number) {
        double total = this._average * (double)this._numValues + number.doubleValue();
        ++this._numValues;
        this._average = total / (double)this._numValues;
        return this;
    }

    public AverageBuilder addValue(Number number, int count) {
        double total = this._average * (double)this._numValues + number.doubleValue() * (double)count;
        this._numValues += count;
        this._average = total / (double)this._numValues;
        return this;
    }

    public double getAverage() {
        if (this._numValues == 0) {
            return Double.NaN;
        }
        return this._average;
    }

    public int getNumValues() {
        return this._numValues;
    }

    public String toString() {
        return "AverageBuilder[average=" + this._average + ",numValues=" + this._numValues + "]";
    }

    public int hashCode() {
        return (int)(this._average + (double)this._numValues);
    }
}

