/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eobjects.analyzer.reference.TextFileDictionary;
import org.eobjects.analyzer.reference.TextFileSynonymCatalog;
import org.eobjects.metamodel.util.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeAwareObjectInputStream
extends ObjectInputStream {
    private static final Logger logger = LoggerFactory.getLogger(ChangeAwareObjectInputStream.class);
    private static final Map<String, Class<?>> PRIMITIVE_CLASSES = new HashMap(8, 1.0f);
    private static final Comparator<String> comparator;
    private final List<ClassLoader> additionalClassLoaders;
    private final Map<String, String> renamedPackages = new TreeMap<String, String>(comparator);
    private final Map<String, String> renamedClasses = new HashMap<String, String>();

    public ChangeAwareObjectInputStream(InputStream in) throws IOException {
        super(in);
        this.additionalClassLoaders = new ArrayList<ClassLoader>();
        this.addRenamedClass("org.eobjects.analyzer.reference.TextBasedDictionary", TextFileDictionary.class);
        this.addRenamedClass("org.eobjects.analyzer.reference.TextBasedSynonymCatalog", TextFileSynonymCatalog.class);
        this.addRenamedClass("org.eobjects.analyzer.result.PatternFinderResult", "org.eobjects.analyzer.beans.stringpattern.PatternFinderResult");
        this.addRenamedClass("org.eobjects.analyzer.result.DateGapAnalyzerResult", "org.eobjects.analyzer.beans.dategap.DateGapAnalyzerResult");
        this.addRenamedClass("org.eobjects.analyzer.util.TimeInterval", "org.eobjects.analyzer.beans.dategap.TimeInterval");
        this.addRenamedClass("org.eobjects.analyzer.result.StringAnalyzerResult", "org.eobjects.analyzer.beans.StringAnalyzerResult");
        this.addRenamedClass("org.eobjects.analyzer.result.NumberAnalyzerResult", "org.eobjects.analyzer.beans.NumberAnalyzerResult");
        this.addRenamedClass("org.eobjects.analyzer.result.BooleanAnalyzerResult", "org.eobjects.analyzer.beans.BooleanAnalyzerResult");
        this.addRenamedClass("org.eobjects.analyzer.result.DateAndTimeAnalyzerResult", "org.eobjects.analyzer.beans.DateAndTimeAnalyzerResult");
        this.addRenamedClass("org.eobjects.analyzer.result.ValueDistributionGroupResult", "org.eobjects.analyzer.beans.valuedist.SingleValueDistributionResult");
        this.addRenamedClass("org.eobjects.analyzer.result.ValueDistributionResult", "org.eobjects.analyzer.beans.valuedist.GroupedValueDistributionResult");
        this.addRenamedClass("org.eobjects.analyzer.beans.valuedist.ValueDistributionGroupResult", "org.eobjects.analyzer.beans.valuedist.SingleValueDistributionResult");
        this.addRenamedClass("org.eobjects.analyzer.beans.valuedist.ValueDistributionResult", "org.eobjects.analyzer.beans.valuedist.GroupedValueDistributionResult");
        this.addRenamedClass("org.eobjects.analyzer.beans.valuedist.ValueCount", "org.eobjects.analyzer.result.SingleValueFrequency");
        this.addRenamedClass("org.eobjects.analyzer.result.ValueCount", "org.eobjects.analyzer.result.SingleValueFrequency");
        this.addRenamedClass("org.eobjects.analyzer.beans.valuedist.ValueCountList", "org.eobjects.analyzer.result.ValueCountList");
        this.addRenamedClass("org.eobjects.analyzer.beans.valuedist.ValueCountListImpl", "org.eobjects.analyzer.result.ValueCountListImpl");
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.additionalClassLoaders.add(classLoader);
    }

    public void addRenamedPackage(String originalPackageName, String newPackageName) {
        this.renamedPackages.put(originalPackageName, newPackageName);
    }

    public void addRenamedClass(String originalClassName, Class<?> newClass) {
        this.addRenamedClass(originalClassName, newClass.getName());
    }

    public void addRenamedClass(String originalClassName, String newClassName) {
        this.renamedClasses.put(originalClassName, newClassName);
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass resultClassDescriptor = super.readClassDescriptor();
        String originalClassName = resultClassDescriptor.getName();
        if (this.renamedClasses.containsKey(originalClassName)) {
            String className = this.renamedClasses.get(originalClassName);
            logger.info("Class '{}' was encountered. Returning class descriptor of new class name: '{}'", (Object)originalClassName, (Object)className);
            return this.getClassDescriptor(className, resultClassDescriptor);
        }
        Set<Map.Entry<String, String>> entrySet = this.renamedPackages.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String legacyPackage = entry.getKey();
            if (!originalClassName.startsWith(legacyPackage)) continue;
            String className = originalClassName.replaceFirst(legacyPackage, entry.getValue());
            logger.info("Class '{}' was encountered. Returning class descriptor of new class name: '{}'", (Object)originalClassName, (Object)className);
            return this.getClassDescriptor(className, resultClassDescriptor);
        }
        return resultClassDescriptor;
    }

    private ObjectStreamClass getClassDescriptor(String className, ObjectStreamClass originalClassDescriptor) throws ClassNotFoundException {
        ObjectStreamClass newClassDescriptor = ObjectStreamClass.lookup(this.resolveClass(className));
        String[] newFieldNames = this.getFieldNames(newClassDescriptor);
        String[] originalFieldNames = this.getFieldNames(originalClassDescriptor);
        if (!EqualsBuilder.equals((Object)originalFieldNames, (Object)newFieldNames)) {
            logger.warn("Field names of original and new class ({}) does not correspond!", (Object)className);
            try {
                Field field = ObjectStreamClass.class.getDeclaredField("name");
                assert (field != null);
                assert (field.getType() == String.class);
                field.setAccessible(true);
                field.set(originalClassDescriptor, className);
                return originalClassDescriptor;
            }
            catch (Exception e) {
                logger.error("Unsuccesful attempt at changing the name of the original class descriptor");
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalStateException(e);
            }
        }
        return newClassDescriptor;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        return this.resolveClass(desc.getName());
    }

    private Class<?> resolveClass(String className) throws ClassNotFoundException {
        logger.debug("Resolving class '{}'", (Object)className);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Class<?> primitiveClass = PRIMITIVE_CLASSES.get(className);
            if (primitiveClass != null) {
                return primitiveClass;
            }
            logger.info("Class '{}' was not resolved in main class loader.", (Object)className);
            ArrayList<ClassNotFoundException> exceptions = new ArrayList<ClassNotFoundException>(this.additionalClassLoaders.size());
            for (ClassLoader classLoader : this.additionalClassLoaders) {
                try {
                    return Class.forName(className, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.info("Class '{}' was not resolved in additional class loader '{}'", (Object)className, (Object)classLoader);
                    exceptions.add(classNotFoundException);
                }
            }
            logger.warn("Could not resolve class of name '{}'", (Object)className);
            int i = 1;
            for (Exception exception : exceptions) {
                int numExceptions = exceptions.size();
                logger.error("Exception " + i + " of " + numExceptions, (Throwable)exception);
                ++i;
            }
            throw e;
        }
    }

    private String[] getFieldNames(ObjectStreamClass classDescriptor) {
        ObjectStreamField[] fields = classDescriptor.getFields();
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = fields[i].getName();
        }
        return fieldNames;
    }

    static {
        PRIMITIVE_CLASSES.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASSES.put("byte", Byte.TYPE);
        PRIMITIVE_CLASSES.put("char", Character.TYPE);
        PRIMITIVE_CLASSES.put("short", Short.TYPE);
        PRIMITIVE_CLASSES.put("int", Integer.TYPE);
        PRIMITIVE_CLASSES.put("long", Long.TYPE);
        PRIMITIVE_CLASSES.put("float", Float.TYPE);
        PRIMITIVE_CLASSES.put("double", Double.TYPE);
        PRIMITIVE_CLASSES.put("void", Void.TYPE);
        comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (EqualsBuilder.equals((Object)o1, (Object)o2)) {
                    return 0;
                }
                int diff = o1.length() - o2.length();
                if (diff == 0) {
                    diff = o1.compareTo(o2);
                }
                return diff;
            }
        };
    }
}

