/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.util;

import java.util.ListIterator;
import org.eobjects.analyzer.util.StringUtils;

public class CharIterator
implements ListIterator<Character> {
    private char[] _chars;
    private int _index = -1;
    private int _length;

    public CharIterator(CharSequence charSequence) {
        this._chars = charSequence == null ? new char[0] : ((Object)charSequence).toString().toCharArray();
        this._length = this._chars.length;
    }

    public CharIterator(char[] chars) {
        this._chars = chars == null ? new char[0] : chars;
        this._length = this._chars.length;
    }

    public void reset() {
        this._index = -1;
    }

    public Character first() {
        this._index = 0;
        return Character.valueOf(this.current());
    }

    public Character last() {
        this._index = this._length - 1;
        return Character.valueOf(this.current());
    }

    public CharIterator subIterator(int fromIndex, int toIndex) {
        int length = toIndex - fromIndex;
        assert (length > 0);
        char[] chars = new char[length];
        System.arraycopy(this._chars, fromIndex, chars, 0, length);
        return new CharIterator(chars);
    }

    public boolean is(Character c) {
        if (c == null) {
            return false;
        }
        return c.charValue() == this.current();
    }

    public boolean isLetter() {
        return Character.isLetter(this.current());
    }

    public boolean isDigit() {
        return Character.isDigit(this.current());
    }

    public boolean isWhitespace() {
        return Character.isWhitespace(this.current());
    }

    public boolean isUpperCase() {
        return Character.isUpperCase(this.current());
    }

    public boolean isLowerCase() {
        return Character.isLowerCase(this.current());
    }

    public boolean isDiacritic() {
        return StringUtils.isDiacritic(this.current());
    }

    @Override
    public boolean hasNext() {
        return this._index + 1 < this._length;
    }

    @Override
    public Character next() {
        ++this._index;
        return Character.valueOf(this.current());
    }

    public int currentIndex() {
        return this._index;
    }

    public char current() {
        return this._chars[this._index];
    }

    @Override
    public boolean hasPrevious() {
        return this._index > 0;
    }

    @Override
    public Character previous() {
        --this._index;
        return Character.valueOf(this.current());
    }

    @Override
    public int nextIndex() {
        return this._index + 1;
    }

    @Override
    public int previousIndex() {
        return this._index - 1;
    }

    @Override
    public void remove() {
        int numMoved = this.length() - this._index - 1;
        if (numMoved > 0) {
            System.arraycopy(this._chars, this._index + 1, this._chars, this._index, numMoved);
        }
        --this._index;
        --this._length;
    }

    @Override
    public void set(Character e) {
        this._chars[this._index] = e.charValue();
    }

    @Override
    public void add(Character e) {
        throw new UnsupportedOperationException("CharIterator does not support add(...)");
    }

    public String toString() {
        int length = this.length();
        if (length != this._chars.length) {
            char[] tmp = this._chars;
            this._chars = new char[length];
            System.arraycopy(tmp, 0, this._chars, 0, length);
        }
        return new String(this._chars);
    }

    public int length() {
        return this._length;
    }
}

