/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.map.ReferenceMap;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.metamodel.util.CollectionUtils;
import org.eobjects.metamodel.util.Predicate;

public final class CollectionUtils2 {
    private CollectionUtils2() {
    }

    public static <E> List<E> refineCandidates(List<E> candidates, Predicate<? super E> predicate) {
        if (candidates.size() == 1) {
            return candidates;
        }
        List newCandidates = CollectionUtils.filter(candidates, predicate);
        if (newCandidates.isEmpty()) {
            return candidates;
        }
        return newCandidates;
    }

    public static <E> List<E> filterOnClass(Collection<?> superTypeList, Class<E> subType) {
        ArrayList result = new ArrayList();
        for (Object object : superTypeList) {
            if (object == null || !ReflectionUtils.is(object.getClass(), subType)) continue;
            result.add(object);
        }
        return result;
    }

    public static <E> E[] array(Class<E> elementClass, Object existingArray, E ... elements) {
        Object[] result;
        if (existingArray == null) {
            return elements;
        }
        if (existingArray.getClass().isArray()) {
            int length = Array.getLength(existingArray);
            result = (Object[])Array.newInstance(elementClass, length + elements.length);
            System.arraycopy(existingArray, 0, result, 0, length);
            System.arraycopy(elements, 0, result, length, elements.length);
        } else {
            result = (Object[])Array.newInstance(elementClass, 1 + elements.length);
            result[0] = existingArray;
            System.arraycopy(elements, 0, result, 1, elements.length);
        }
        return result;
    }

    public static <E> E[] arrayOf(Class<E> elementClass, Object arrayOrElement) {
        if (arrayOrElement == null) {
            return null;
        }
        if (arrayOrElement.getClass().isArray()) {
            return (Object[])arrayOrElement;
        }
        Object result = Array.newInstance(elementClass, 1);
        Array.set(result, 0, arrayOrElement);
        return (Object[])result;
    }

    public static <E> List<E> sorted(Collection<E> col, Comparator<? super E> comparator) {
        ArrayList<E> list = new ArrayList<E>(col);
        Collections.sort(list, comparator);
        return list;
    }

    public static <E extends Comparable<E>> List<E> sorted(Collection<E> col) {
        ArrayList<E> list = new ArrayList<E>(col);
        Collections.sort(list);
        return list;
    }

    public static <K, V> Map<K, V> createCacheMap() {
        return new ReferenceMap(1, 1, true);
    }

    public static Object toArray(List<?> list, Class<?> componentType) {
        Object result;
        block10: {
            int size;
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block9: {
                                            size = list.size();
                                            result = Array.newInstance(componentType, size);
                                            if (componentType.isPrimitive()) break block9;
                                            for (int i = 0; i < size; ++i) {
                                                Array.set(result, i, list.get(i));
                                            }
                                            break block10;
                                        }
                                        if (componentType != Boolean.TYPE) break block11;
                                        for (int i = 0; i < size; ++i) {
                                            Array.setBoolean(result, i, (Boolean)list.get(i));
                                        }
                                        break block10;
                                    }
                                    if (componentType != Byte.TYPE) break block12;
                                    for (int i = 0; i < size; ++i) {
                                        Array.setByte(result, i, (Byte)list.get(i));
                                    }
                                    break block10;
                                }
                                if (componentType != Short.TYPE) break block13;
                                for (int i = 0; i < size; ++i) {
                                    Array.setShort(result, i, (Short)list.get(i));
                                }
                                break block10;
                            }
                            if (componentType != Integer.TYPE) break block14;
                            for (int i = 0; i < size; ++i) {
                                Array.setInt(result, i, (Integer)list.get(i));
                            }
                            break block10;
                        }
                        if (componentType != Long.TYPE) break block15;
                        for (int i = 0; i < size; ++i) {
                            Array.setLong(result, i, (Long)list.get(i));
                        }
                        break block10;
                    }
                    if (componentType != Float.TYPE) break block16;
                    for (int i = 0; i < size; ++i) {
                        Array.setFloat(result, i, ((Float)list.get(i)).floatValue());
                    }
                    break block10;
                }
                if (componentType != Double.TYPE) break block17;
                for (int i = 0; i < size; ++i) {
                    Array.setDouble(result, i, (Double)list.get(i));
                }
                break block10;
            }
            if (componentType != Character.TYPE) break block10;
            for (int i = 0; i < size; ++i) {
                Array.setChar(result, i, ((Character)list.get(i)).charValue());
            }
        }
        return result;
    }
}

