/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.util;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.descriptors.AnalyzerBeanDescriptor;
import org.eobjects.analyzer.job.AnalyzerJob;
import org.eobjects.analyzer.job.ComponentJob;
import org.eobjects.analyzer.job.ConfigurableBeanJob;
import org.eobjects.analyzer.job.FilterJob;
import org.eobjects.analyzer.job.FilterOutcome;
import org.eobjects.analyzer.job.MergeInput;
import org.eobjects.analyzer.job.MergedOutcome;
import org.eobjects.analyzer.job.MergedOutcomeJob;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.MergeInputBuilder;
import org.eobjects.analyzer.job.builder.MergedOutcomeJobBuilder;
import org.eobjects.analyzer.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LabelUtils {
    private static final Logger logger = LoggerFactory.getLogger(LabelUtils.class);
    public static final String NULL_LABEL = "<null>";
    public static final String UNIQUE_LABEL = "<unique>";
    public static final String BLANK_LABEL = "<blank>";
    public static final String UNEXPECTED_LABEL = "<unexpected>";
    public static final String COUNT_LABEL = "COUNT(*)";

    private LabelUtils() {
    }

    public static String getLabel(AbstractBeanJobBuilder<?, ?, ?> builder) {
        String label = builder.getName();
        if (StringUtils.isNullOrEmpty(label)) {
            label = builder.getDescriptor().getDisplayName();
        }
        return label;
    }

    public static String getLabel(ComponentJob job) {
        return LabelUtils.getLabel(job, false, true, true);
    }

    public static String getLabel(ComponentJob job, boolean includeDescriptorName, boolean includeInputColumnNames, boolean includeRequirements) {
        String jobName = job.getName();
        StringBuilder label = new StringBuilder();
        if (StringUtils.isNullOrEmpty(jobName)) {
            if (job instanceof ConfigurableBeanJob) {
                Object descriptor = ((ConfigurableBeanJob)job).getDescriptor();
                label.append(descriptor.getDisplayName());
            } else if (job instanceof MergedOutcomeJob) {
                MergeInput[] inputs = ((MergedOutcomeJob)job).getMergeInputs();
                label.append("MergedOutcome[");
                label.append(inputs.length);
                label.append(']');
            } else {
                label.append(job.toString());
            }
        } else {
            label.append(jobName);
        }
        if (job instanceof AnalyzerJob) {
            InputColumn[] input;
            AnalyzerJob analyzerJob = (AnalyzerJob)job;
            if (includeDescriptorName && !StringUtils.isNullOrEmpty(jobName)) {
                label.append(" (");
                label.append(((AnalyzerBeanDescriptor)analyzerJob.getDescriptor()).getDisplayName());
                label.append(')');
            }
            if ((input = analyzerJob.getInput()).length == 1 && input[0].getName().equals(jobName)) {
                includeInputColumnNames = false;
            }
            if (includeInputColumnNames && input.length > 0) {
                label.append(" (");
                if (input.length < 5) {
                    for (int i = 0; i < input.length; ++i) {
                        if (i != 0) {
                            label.append(',');
                        }
                        label.append(input[i].getName());
                    }
                } else {
                    label.append(input.length);
                    label.append(" columns");
                }
                label.append(")");
            }
            Outcome[] requirements = analyzerJob.getRequirements();
            if (includeRequirements && requirements != null && requirements.length != 0) {
                label.append(" (");
                for (int i = 0; i < requirements.length; ++i) {
                    if (i != 0) {
                        label.append(" ,");
                    }
                    LabelUtils.appendRequirement(label, requirements[i]);
                }
                label.append(")");
            }
        }
        return label.toString();
    }

    private static void appendRequirement(StringBuilder sb, Outcome req) {
        if (req instanceof FilterOutcome) {
            FilterJob filterJob = ((FilterOutcome)req).getFilterJob();
            Enum<?> category = ((FilterOutcome)req).getCategory();
            String filterLabel = LabelUtils.getLabel(filterJob);
            sb.append(filterLabel);
            sb.append("=");
            sb.append(category);
        } else if (req instanceof MergedOutcome) {
            sb.append('[');
            MergedOutcomeJob mergedOutcomeJob = ((MergedOutcome)req).getMergedOutcomeJob();
            MergeInput[] mergeInputs = mergedOutcomeJob.getMergeInputs();
            for (int i = 0; i < mergeInputs.length; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                MergeInput mergeInput = mergeInputs[i];
                Outcome outcome = mergeInput.getOutcome();
                LabelUtils.appendRequirement(sb, outcome);
            }
            sb.append(']');
        } else {
            sb.append(req.toString());
        }
    }

    public static String getLabel(MergedOutcomeJobBuilder builder) {
        String label = builder.getName();
        if (StringUtils.isNullOrEmpty(label)) {
            List<MergeInputBuilder> inputs = builder.getMergeInputs();
            StringBuilder sb = new StringBuilder();
            sb.append("MergedOutcome[");
            sb.append(inputs.size());
            sb.append(']');
        }
        return label;
    }

    public static String getLabel(String text) {
        if (text == null) {
            return NULL_LABEL;
        }
        if ("".equals(text)) {
            return BLANK_LABEL;
        }
        return text;
    }

    public static String getDataTypeLabel(Class<?> dataType) {
        if (dataType == null) {
            return "<undefined>";
        }
        return dataType.getSimpleName();
    }

    public static String getValueLabel(Object value) {
        if (value == null) {
            return NULL_LABEL;
        }
        if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
            NumberFormat format = NumberFormat.getNumberInstance();
            String result = format.format((Number)value);
            logger.debug("Formatted decimal {} to: {}", value, (Object)result);
            return result;
        }
        if (value instanceof Date) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String result = format.format((Date)value);
            logger.debug("Formatted date {} to: {}", value, (Object)result);
            return result;
        }
        return LabelUtils.getLabel(value.toString());
    }
}

