/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.util;

public class Percentage
extends Number {
    private static final long serialVersionUID = 1L;
    private short percentage;

    public Percentage(int nominator) {
        this((short)nominator);
    }

    public Percentage(short nominator) {
        if (nominator < 0 || nominator > 100) {
            throw new IllegalArgumentException("Percentage nominator has to be between 0 and 100. Invalid: " + nominator);
        }
        this.percentage = nominator;
    }

    public int getNominator() {
        return this.percentage;
    }

    public int getDenominator() {
        return 100;
    }

    @Override
    public int intValue() {
        return this.percentage / 100;
    }

    @Override
    public long longValue() {
        return this.percentage / 100;
    }

    @Override
    public float floatValue() {
        return (float)this.percentage / 100.0f;
    }

    @Override
    public double doubleValue() {
        return (double)this.percentage / 100.0;
    }

    public String toString() {
        return this.percentage + "%";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.percentage;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Percentage other = (Percentage)obj;
        return this.percentage == other.percentage;
    }

    public static Percentage parsePercentage(String str) throws NumberFormatException {
        if (str == null) {
            throw new NumberFormatException("cannot parse null");
        }
        if ((str = str.trim()).length() == 0 || str.length() > 4) {
            throw new NumberFormatException(str);
        }
        char percentageSymbol = str.charAt(str.length() - 1);
        if (percentageSymbol != '%') {
            throw new NumberFormatException(str);
        }
        str = str.substring(0, str.length() - 1);
        short p = Short.parseShort(str);
        return new Percentage(p);
    }
}

