/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eobjects.analyzer.data.DataTypeFamily;
import org.eobjects.analyzer.data.ExpressionBasedInputColumn;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.InputColumnSinkJob;
import org.eobjects.analyzer.job.InputColumnSourceJob;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.job.OutcomeSinkJob;
import org.eobjects.analyzer.job.OutcomeSourceJob;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.SourceColumns;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceColumnFinder {
    private static final Logger logger = LoggerFactory.getLogger(SourceColumnFinder.class);
    private Set<InputColumnSinkJob> _inputColumnSinks = new HashSet<InputColumnSinkJob>();
    private Set<InputColumnSourceJob> _inputColumnSources = new HashSet<InputColumnSourceJob>();
    private Set<OutcomeSourceJob> _outcomeSources = new HashSet<OutcomeSourceJob>();
    private Set<OutcomeSinkJob> _outcomeSinks = new HashSet<OutcomeSinkJob>();

    private void addSources(Object ... sources) {
        for (Object source : sources) {
            if (source instanceof InputColumnSinkJob) {
                this._inputColumnSinks.add((InputColumnSinkJob)source);
            }
            if (source instanceof InputColumnSourceJob) {
                this._inputColumnSources.add((InputColumnSourceJob)source);
            }
            if (source instanceof OutcomeSourceJob) {
                this._outcomeSources.add((OutcomeSourceJob)source);
            }
            if (!(source instanceof OutcomeSinkJob)) continue;
            this._outcomeSinks.add((OutcomeSinkJob)source);
        }
    }

    private void addSources(Collection<?> sources) {
        this.addSources(sources.toArray());
    }

    public void addSources(AnalysisJobBuilder job) {
        this.addSources(new SourceColumns(job.getSourceColumns()));
        this.addSources(job.getFilterJobBuilders());
        this.addSources(job.getTransformerJobBuilders());
        this.addSources(job.getMergedOutcomeJobBuilders());
        this.addSources(job.getAnalyzerJobBuilders());
    }

    public void addSources(AnalysisJob job) {
        this.addSources(new SourceColumns(job.getSourceColumns()));
        this.addSources(job.getFilterJobs());
        this.addSources(job.getTransformerJobs());
        this.addSources(job.getMergedOutcomeJobs());
        this.addSources(job.getAnalyzerJobs());
    }

    public List<InputColumn<?>> findInputColumns(Class<?> dataType) {
        return this.findInputColumns(null, dataType);
    }

    @Deprecated
    public List<InputColumn<?>> findInputColumns(DataTypeFamily dataTypeFamily, Class<?> dataType) {
        if (dataTypeFamily == null) {
            dataTypeFamily = DataTypeFamily.UNDEFINED;
        }
        ArrayList result = new ArrayList();
        for (InputColumnSourceJob source : this._inputColumnSources) {
            InputColumn<?>[] outputColumns;
            for (InputColumn<?> col : outputColumns = source.getOutput()) {
                DataTypeFamily columnFamily = col.getDataTypeFamily();
                if (columnFamily != dataTypeFamily && dataTypeFamily != DataTypeFamily.UNDEFINED) continue;
                Class columnDataType = col.getDataType();
                if (dataType == null || columnDataType == null) {
                    result.add(col);
                    continue;
                }
                if (!ReflectionUtils.is(columnDataType, dataType)) continue;
                result.add(col);
            }
        }
        return result;
    }

    public Set<Object> findAllSourceJobs(Object job) {
        HashSet<Object> result = new HashSet<Object>();
        this.findAllSourceJobs(job, result);
        return result;
    }

    private void findAllSourceJobs(Object job, Set<Object> result) {
        Object source;
        if (job instanceof InputColumnSinkJob) {
            InputColumn<?>[] inputColumns;
            for (InputColumn<?> inputColumn : inputColumns = ((InputColumnSinkJob)job).getInput()) {
                source = this.findInputColumnSource(inputColumn);
                if (source == null) continue;
                result.add(source);
                this.findAllSourceJobs(source, result);
            }
        }
        if (job instanceof OutcomeSinkJob) {
            Outcome[] requirements;
            for (Outcome outcome : requirements = ((OutcomeSinkJob)job).getRequirements()) {
                source = this.findOutcomeSource(outcome);
                if (source == null) continue;
                result.add(source);
                this.findAllSourceJobs(source, result);
            }
        }
    }

    public InputColumnSourceJob findInputColumnSource(InputColumn<?> inputColumn) {
        if (inputColumn instanceof ExpressionBasedInputColumn) {
            return null;
        }
        for (InputColumnSourceJob source : this._inputColumnSources) {
            InputColumn<?>[] output;
            for (InputColumn<?> column : output = source.getOutput()) {
                if (!inputColumn.equals(column)) continue;
                return source;
            }
        }
        return null;
    }

    public OutcomeSourceJob findOutcomeSource(Outcome requirement) {
        for (OutcomeSourceJob source : this._outcomeSources) {
            Outcome[] outcomes;
            for (Outcome outcome : outcomes = source.getOutcomes()) {
                if (!requirement.equals(outcome)) continue;
                return source;
            }
        }
        return null;
    }

    public Set<Column> findOriginatingColumns(Outcome requirement) {
        OutcomeSourceJob source = this.findOutcomeSource(requirement);
        HashSet<Column> result = new HashSet<Column>();
        this.findOriginatingColumnsOfSource(source, result);
        return result;
    }

    public Table findOriginatingTable(Outcome requirement) {
        OutcomeSourceJob source = this.findOutcomeSource(requirement);
        return this.findOriginatingTableOfSource(source);
    }

    public Table findOriginatingTable(InputColumn<?> inputColumn) {
        if (inputColumn == null) {
            logger.warn("InputColumn was null, no originating table found");
            return null;
        }
        if (inputColumn.isPhysicalColumn()) {
            return inputColumn.getPhysicalColumn().getTable();
        }
        return this.findOriginatingTableOfSource(this.findInputColumnSource(inputColumn));
    }

    private Table findOriginatingTableOfSource(Object source) {
        Outcome[] requirements;
        Table table;
        InputColumn<?>[] input;
        TreeSet<Table> result = new TreeSet<Table>();
        if (source instanceof InputColumnSinkJob && (input = ((InputColumnSinkJob)source).getInput()) != null) {
            for (InputColumn<?> inputColumn : input) {
                if (inputColumn == null) {
                    logger.warn("InputColumn sink had a null-column element!");
                    continue;
                }
                table = this.findOriginatingTable(inputColumn);
                if (table == null) continue;
                result.add(table);
            }
        }
        if (source instanceof OutcomeSinkJob && (requirements = ((OutcomeSinkJob)source).getRequirements()) != null) {
            for (Outcome outcome : requirements) {
                table = this.findOriginatingTable(outcome);
                if (table == null) continue;
                result.add(table);
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() == 1) {
            return (Table)result.iterator().next();
        }
        StringBuilder sb = new StringBuilder();
        for (Table table2 : result) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(table2.getName());
        }
        throw new IllegalStateException("Multiple originating tables (" + sb + ") found for source: " + source);
    }

    private void findOriginatingColumnsOfInputColumn(InputColumn<?> inputColumn, Set<Column> result) {
        if (inputColumn == null) {
            return;
        }
        if (inputColumn.isPhysicalColumn()) {
            result.add(inputColumn.getPhysicalColumn());
        } else {
            InputColumnSourceJob source = this.findInputColumnSource(inputColumn);
            this.findOriginatingColumnsOfSource(source, result);
        }
    }

    private void findOriginatingColumnsOfOutcome(Outcome requirement, Set<Column> result) {
        OutcomeSourceJob source = this.findOutcomeSource(requirement);
        this.findOriginatingColumnsOfSource(source, result);
    }

    private void findOriginatingColumnsOfSource(Object source, Set<Column> result) {
        InputColumn<?>[] input;
        if (source == null) {
            return;
        }
        if (source instanceof InputColumnSinkJob && (input = ((InputColumnSinkJob)source).getInput()) != null) {
            for (InputColumn<?> inputColumn : input) {
                this.findOriginatingColumnsOfInputColumn(inputColumn, result);
            }
        }
        if (source instanceof OutcomeSinkJob) {
            Outcome[] requirements;
            for (Outcome outcome : requirements = ((OutcomeSinkJob)source).getRequirements()) {
                this.findOriginatingColumnsOfOutcome(outcome, result);
            }
        }
    }

    public Set<Column> findOriginatingColumns(InputColumn<?> inputColumn) {
        HashSet<Column> result = new HashSet<Column>();
        this.findOriginatingColumnsOfInputColumn(inputColumn, result);
        return result;
    }
}

