/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.util;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UsageAwareCloseable
implements Closeable {
    private static final int STACK_TRACE_ELEMENTS_TO_LOG = 7;
    private final Logger _logger;
    private final AtomicInteger _usageCount;
    private final AtomicBoolean _closed;
    private final List<CloseEvent> _closeEvents;

    public UsageAwareCloseable() {
        this(LoggerFactory.getLogger(UsageAwareCloseable.class));
    }

    public UsageAwareCloseable(Logger logger) {
        this._logger = logger;
        this._usageCount = new AtomicInteger(1);
        this._closed = new AtomicBoolean(false);
        if (logger.isDebugEnabled()) {
            this._closeEvents = new ArrayList<CloseEvent>(2);
            logger.debug("{} instantiated by:", (Object)this.getClass().getSimpleName());
            this.logNearestStack();
        } else {
            this._closeEvents = null;
        }
    }

    private void logNearestStack() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        for (int i = 1; i < stackTrace.length && i < 7; ++i) {
            StackTraceElement ste = stackTrace[i];
            this._logger.debug(" - {} @ line {}", (Object)ste.getClassName(), (Object)ste.getLineNumber());
        }
    }

    private void logStack(StackTraceElement[] stackTrace) {
        for (int i = 1; i < stackTrace.length && i < 7; ++i) {
            StackTraceElement ste = stackTrace[i];
            this._logger.debug(" - {} @ line {}", (Object)ste.getClassName(), (Object)ste.getLineNumber());
        }
    }

    protected abstract void closeInternal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean requestUsage() {
        int usage;
        if (this.isClosed()) {
            return false;
        }
        UsageAwareCloseable usageAwareCloseable = this;
        synchronized (usageAwareCloseable) {
            usage = this._usageCount.incrementAndGet();
            if (usage == 1) {
                this._usageCount.decrementAndGet();
                this._logger.debug("{} is closed, request for more usage refused", (Object)this.getClass().getSimpleName());
                return false;
            }
        }
        this._logger.debug("Usage incremented to {} for {}", (Object)usage, (Object)this);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Incremented usage by:");
            this.logNearestStack();
        }
        return true;
    }

    public final boolean isClosed() {
        return this._closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        if (this.isClosed()) {
            this._logger.warn(this + " is already closed, but close() was invoked!");
            if (this._logger.isDebugEnabled()) {
                this._closeEvents.add(new CloseEvent(Thread.currentThread().getName(), new Throwable().getStackTrace()));
                int numCloses = this._closeEvents.size();
                int i = 1;
                for (CloseEvent closeEvent : this._closeEvents) {
                    this._logger.debug("Stack trace when close() no. {} of {}: ", (Object)i, (Object)numCloses);
                    this._logger.debug("Thread name: {}", (Object)closeEvent.threadName);
                    this.logStack(closeEvent.stackTrace);
                    ++i;
                }
            }
            return;
        }
        UsageAwareCloseable usageAwareCloseable = this;
        synchronized (usageAwareCloseable) {
            int usage = this._usageCount.decrementAndGet();
            this._logger.debug("Method close() invoked, usage decremented to {} for {}", (Object)this._usageCount, (Object)this);
            if (usage == 0) {
                if (this._logger.isDebugEnabled()) {
                    this._closeEvents.add(new CloseEvent(Thread.currentThread().getName(), new Throwable().getStackTrace()));
                }
                this._logger.debug("Closing {}", (Object)this);
                this.closeInternal();
                this._closed.set(true);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isClosed()) {
            if (this._logger.isWarnEnabled()) {
                this._logger.warn("Method finalize() invoked but not all usages closed ({} remaining) (for {}). Closing.", (Object)this._usageCount, (Object)this);
            }
            this.closeInternal();
        }
    }

    protected int getUsageCount() {
        return this._usageCount.get();
    }

    private static class CloseEvent {
        final String threadName;
        final StackTraceElement[] stackTrace;

        CloseEvent(String name, StackTraceElement[] trace) {
            this.threadName = name;
            this.stackTrace = trace;
        }
    }
}

