/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.util.batch;

import org.eobjects.analyzer.beans.api.Close;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.util.batch.BatchTransformation;
import org.eobjects.analyzer.util.batch.BatchTransformationBuffer;

public abstract class BatchTransformer
implements Transformer<Object>,
BatchTransformation<InputRow, Object[]> {
    private final BatchTransformationBuffer<InputRow, Object[]> _batchTransformationBuffer = new BatchTransformationBuffer<InputRow, Object[]>(this, this.getMaxBatchSize(), this.getFlushIntervalMillis());

    protected int getFlushIntervalMillis() {
        return 1000;
    }

    protected int getMaxBatchSize() {
        return 20;
    }

    @Initialize
    public final void initialize() {
        this._batchTransformationBuffer.start();
    }

    @Close
    public final void close() {
        this._batchTransformationBuffer.shutdown();
    }

    public final Object[] transform(InputRow inputRow) {
        return this._batchTransformationBuffer.transform(inputRow);
    }
}

