/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.util.convert;

import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Converter;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.reference.Dictionary;
import org.eobjects.analyzer.reference.ReferenceDataCatalog;
import org.eobjects.analyzer.reference.StringPattern;
import org.eobjects.analyzer.reference.SynonymCatalog;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationItemConverter
implements Converter<Object> {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationItemConverter.class);
    @Inject
    DatastoreCatalog datastoreCatalog;
    @Inject
    ReferenceDataCatalog referenceDataCatalog;
    @Inject
    Datastore datastore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fromString(Class<?> type, String str) {
        if (ReflectionUtils.isColumn(type)) {
            DatastoreConnection connection = this.datastore.openConnection();
            try {
                Column column = connection.getSchemaNavigator().convertToColumn(str);
                if (column == null) {
                    throw new IllegalArgumentException("Column not found: " + str);
                }
                Column column2 = column;
                return column2;
            }
            finally {
                connection.close();
            }
        }
        if (ReflectionUtils.isTable(type)) {
            DatastoreConnection connection = this.datastore.openConnection();
            try {
                Table table = connection.getSchemaNavigator().convertToTable(str);
                if (table == null) {
                    throw new IllegalArgumentException("Table not found: " + str);
                }
                Table table2 = table;
                return table2;
            }
            finally {
                connection.close();
            }
        }
        if (ReflectionUtils.isSchema(type)) {
            DatastoreConnection connection = this.datastore.openConnection();
            try {
                Schema schema = connection.getSchemaNavigator().convertToSchema(str);
                if (schema == null) {
                    throw new IllegalArgumentException("Schema not found: " + str);
                }
                Schema schema2 = schema;
                return schema2;
            }
            finally {
                connection.close();
            }
        }
        if (ReflectionUtils.is(type, Dictionary.class)) {
            Dictionary dictionary = this.referenceDataCatalog.getDictionary(str);
            if (dictionary == null) {
                throw new IllegalArgumentException("Dictionary not found: " + str);
            }
            return dictionary;
        }
        if (ReflectionUtils.is(type, SynonymCatalog.class)) {
            SynonymCatalog synonymCatalog = this.referenceDataCatalog.getSynonymCatalog(str);
            if (synonymCatalog == null) {
                throw new IllegalArgumentException("Synonym catalog not found: " + str);
            }
            return synonymCatalog;
        }
        if (ReflectionUtils.is(type, StringPattern.class)) {
            StringPattern stringPattern = this.referenceDataCatalog.getStringPattern(str);
            if (stringPattern == null) {
                throw new IllegalArgumentException("String pattern not found: " + str);
            }
            return stringPattern;
        }
        if (ReflectionUtils.is(type, Datastore.class) && null != this.datastoreCatalog) {
            Datastore datastore = this.datastoreCatalog.getDatastore(str);
            if (datastore == null) {
                throw new IllegalArgumentException("Datastore not found: " + str);
            }
            return datastore;
        }
        throw new IllegalArgumentException("Could not convert to type: " + type.getName());
    }

    public String toString(Object o) {
        String result;
        if (o instanceof Schema) {
            result = ((Schema)o).getName();
        } else if (o instanceof Table) {
            result = ((Table)o).getQualifiedLabel();
        } else if (o instanceof Column) {
            result = ((Column)o).getQualifiedLabel();
        } else if (o instanceof Dictionary) {
            result = ((Dictionary)o).getName();
        } else if (o instanceof SynonymCatalog) {
            result = ((SynonymCatalog)o).getName();
        } else if (o instanceof StringPattern) {
            result = ((StringPattern)o).getName();
        } else if (o instanceof Datastore) {
            result = ((Datastore)o).getName();
        } else {
            logger.warn("Could not convert type: {}", (Object)o.getClass().getName());
            result = o.toString();
        }
        return result;
    }

    public boolean isConvertable(Class<?> type) {
        return ReflectionUtils.isSchema(type) || ReflectionUtils.isTable(type) || ReflectionUtils.isColumn(type) || ReflectionUtils.is(type, Dictionary.class) || ReflectionUtils.is(type, SynonymCatalog.class) || ReflectionUtils.is(type, StringPattern.class) || ReflectionUtils.is(type, Datastore.class);
    }
}

