/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.util.convert;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Converter;
import org.eobjects.analyzer.configuration.InjectionManager;
import org.eobjects.analyzer.lifecycle.MemberInjectionPoint;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.analyzer.util.convert.ArrayConverter;
import org.eobjects.analyzer.util.convert.NullConverter;

public class DelegatingConverter
implements Converter<Object> {
    private static final String[][] ESCAPE_MAPPING = new String[][]{{"&amp;", "&"}, {"&#91;", "["}, {"&#93;", "]"}, {"&#44;", ","}, {"&lt;", "<"}, {"&gt;", ">"}, {"&quot;", "\""}, {"&copy;", "\u00a9"}, {"&reg;", "\u00ae"}, {"&euro;", "\u20a0"}};
    private final List<Converter<?>> _converters = new ArrayList();
    private final NullConverter _nullConverter = new NullConverter();
    private final ArrayConverter _arrayConverter = new ArrayConverter(this);

    public DelegatingConverter() {
        this(null);
    }

    public DelegatingConverter(Collection<Converter<?>> converters) {
        if (converters != null) {
            this._converters.addAll(converters);
        }
    }

    public List<Converter<?>> getConverters() {
        return this._converters;
    }

    public void addConverter(Converter<?> converter) {
        this._converters.add(converter);
    }

    public Object fromString(Class<?> type, String serializedForm) {
        if (type == null || serializedForm == null || this._nullConverter.isNull(serializedForm)) {
            return this._nullConverter.fromString(type, serializedForm);
        }
        if (type.isArray()) {
            return this._arrayConverter.fromString(type, serializedForm);
        }
        serializedForm = DelegatingConverter.unescape(serializedForm);
        for (Converter<?> converter : this._converters) {
            if (!converter.isConvertable(type)) continue;
            Object result = converter.fromString(type, serializedForm);
            return result;
        }
        if (ReflectionUtils.is(type, List.class)) {
            return this._arrayConverter.fromString(type, serializedForm);
        }
        throw new IllegalStateException("Could not find matching converter for type: " + type);
    }

    public String toString(Object instance) {
        if (null == instance) {
            return this._nullConverter.toString(instance);
        }
        Class<?> type = instance.getClass();
        if (this._arrayConverter.isConvertable(type)) {
            return this._arrayConverter.toString(instance);
        }
        for (Converter<?> converter : this._converters) {
            if (!converter.isConvertable(type)) continue;
            Converter<?> castedConverter = converter;
            String serializedForm = castedConverter.toString(instance);
            serializedForm = DelegatingConverter.escape(serializedForm);
            return serializedForm;
        }
        throw new IllegalStateException("Could not find matching converter for instance: " + instance);
    }

    public boolean isConvertable(Class<?> instance) {
        return true;
    }

    public void initializeAll(InjectionManager injectionManager) {
        if (injectionManager != null) {
            for (Converter<?> converter : this._converters) {
                Field[] fields;
                for (Field field : fields = ReflectionUtils.getFields(converter.getClass(), Inject.class)) {
                    DelegatingConverter value;
                    if (field.getType() == Converter.class) {
                        value = this;
                    } else {
                        MemberInjectionPoint injectionPoint = new MemberInjectionPoint(field, converter);
                        value = injectionManager.getInstance(injectionPoint);
                    }
                    field.setAccessible(true);
                    try {
                        field.set(converter, value);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Could not initialize converter: " + converter, e);
                    }
                }
            }
        }
    }

    private static final String escape(String str) {
        for (String[] mapping : ESCAPE_MAPPING) {
            String escapedValue = mapping[1];
            if (!str.contains(escapedValue)) continue;
            str = str.replace(escapedValue, mapping[0]);
        }
        return str;
    }

    private static final String unescape(String str) {
        for (String[] mapping : ESCAPE_MAPPING) {
            String unescapedValue = mapping[0];
            if (!str.contains(unescapedValue)) continue;
            str = str.replaceAll(unescapedValue, mapping[1]);
        }
        return str;
    }
}

