/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.util.convert;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eobjects.analyzer.beans.api.Converter;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.analyzer.util.convert.ClasspathResourceTypeHandler;
import org.eobjects.analyzer.util.convert.FileResourceTypeHandler;
import org.eobjects.analyzer.util.convert.UrlResourceTypeHandler;
import org.eobjects.analyzer.util.convert.VfsResourceTypeHandler;
import org.eobjects.metamodel.util.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceConverter
implements Converter<Resource> {
    private static final Logger logger = LoggerFactory.getLogger(ResourceConverter.class);
    public static final String DEFAULT_DEFAULT_SCHEME = "file";
    private static final Pattern RESOURCE_PATTERN = Pattern.compile("\\b([a-zA-Z]+)://(.+)");
    private static final Collection<ResourceTypeHandler<?>> DEFAULT_HANDLERS = Arrays.asList(new FileResourceTypeHandler(), new UrlResourceTypeHandler(), new ClasspathResourceTypeHandler(), new VfsResourceTypeHandler());
    private final Map<String, ResourceTypeHandler<?>> _parsers;
    private final String _defaultScheme;

    public ResourceConverter() {
        this(DEFAULT_HANDLERS, DEFAULT_DEFAULT_SCHEME);
    }

    public ResourceConverter(Collection<? extends ResourceTypeHandler<?>> handlers, String defaultScheme) {
        this._defaultScheme = defaultScheme;
        this._parsers = new ConcurrentHashMap();
        for (ResourceTypeHandler<?> handler : handlers) {
            String scheme = handler.getScheme();
            this._parsers.put(scheme, handler);
        }
    }

    public ResourceConverter(ResourceTypeHandler<?> ... handlers) {
        this(Arrays.asList(handlers), DEFAULT_DEFAULT_SCHEME);
    }

    public Resource fromString(Class<?> type, String serializedForm) {
        ResourceStructure structure = this.parseStructure(serializedForm);
        if (structure == null) {
            throw new IllegalStateException("Invalid resource format: " + serializedForm);
        }
        String scheme = structure.getScheme();
        ResourceTypeHandler<?> handler = this._parsers.get(scheme);
        if (handler == null) {
            throw new IllegalStateException("No handler found for scheme of resource: " + serializedForm);
        }
        Object resource = handler.parsePath(structure.getPath());
        return resource;
    }

    public String toString(Resource resource) {
        Class<?> resourceType = resource.getClass();
        Collection<ResourceTypeHandler<?>> values = this._parsers.values();
        for (ResourceTypeHandler<?> handler : values) {
            if (!handler.isParserFor(resourceType)) continue;
            String path = handler.createPath(resource);
            String scheme = handler.getScheme();
            return scheme + "://" + path;
        }
        throw new IllegalStateException("Could not find a resource handler for resource: " + resource);
    }

    public boolean isConvertable(Class<?> type) {
        return ReflectionUtils.is(type, Resource.class);
    }

    public ResourceStructure parseStructure(String str) {
        Matcher matcher = RESOURCE_PATTERN.matcher(str);
        if (!matcher.find()) {
            logger.info("Did not find any scheme definition in resource path: {}. Using default scheme: {}.", (Object)str, (Object)this._defaultScheme);
            return new ResourceStructure(this._defaultScheme, str);
        }
        String scheme = matcher.group(1);
        String path = matcher.group(2);
        return new ResourceStructure(scheme, path);
    }

    public static class ResourceStructure {
        private final String scheme;
        private final String path;

        public ResourceStructure(String scheme, String path) {
            this.scheme = scheme;
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String getScheme() {
            return this.scheme;
        }
    }

    public static interface ResourceTypeHandler<E extends Resource> {
        public boolean isParserFor(Class<? extends Resource> var1);

        public String getScheme();

        public E parsePath(String var1);

        public String createPath(Resource var1);
    }
}

