/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.util.convert;

import java.util.ArrayList;
import java.util.Collection;
import org.eobjects.analyzer.beans.api.Convertable;
import org.eobjects.analyzer.beans.api.Converter;
import org.eobjects.analyzer.configuration.InjectionManager;
import org.eobjects.analyzer.configuration.SimpleInjectionPoint;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.analyzer.util.convert.ConfigurationItemConverter;
import org.eobjects.analyzer.util.convert.DelegatingConverter;
import org.eobjects.analyzer.util.convert.ResourceConverter;
import org.eobjects.analyzer.util.convert.StandardTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringConverter {
    private static final Logger logger = LoggerFactory.getLogger(StringConverter.class);
    private final InjectionManager _injectionManager;

    public StringConverter(InjectionManager injectionManager) {
        this._injectionManager = injectionManager;
    }

    public final String serialize(Object o) {
        return this.serialize(o, new ArrayList(0));
    }

    public final String serialize(Object o, Class<? extends Converter<?>> converterClass) {
        ArrayList col = new ArrayList();
        if (converterClass != null) {
            col.add(converterClass);
        }
        return this.serialize(o, col);
    }

    public final String serialize(Object o, Collection<Class<? extends Converter<?>>> converterClasses) {
        Convertable convertable;
        DelegatingConverter delegatingConverter = new DelegatingConverter();
        if (converterClasses != null) {
            for (Class<Converter<?>> clazz : converterClasses) {
                delegatingConverter.addConverter(this.createConverter(clazz));
            }
        }
        if (o != null && (convertable = ReflectionUtils.getAnnotation(o.getClass(), Convertable.class)) != null) {
            Class clazz = convertable.value();
            delegatingConverter.addConverter(this.createConverter(clazz));
        }
        delegatingConverter.addConverter(new ConfigurationItemConverter());
        delegatingConverter.addConverter(this.getResourceConverter());
        delegatingConverter.addConverter(new StandardTypeConverter(delegatingConverter));
        delegatingConverter.initializeAll(this._injectionManager);
        return delegatingConverter.toString(o);
    }

    private ResourceConverter getResourceConverter() {
        if (this._injectionManager == null) {
            return new ResourceConverter();
        }
        ResourceConverter converter = this._injectionManager.getInstance(SimpleInjectionPoint.of(ResourceConverter.class));
        if (converter == null) {
            return new ResourceConverter();
        }
        return converter;
    }

    private Converter<?> createConverter(Class<? extends Converter<?>> converterClass) {
        try {
            Converter<?> converter = converterClass.newInstance();
            return converter;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException("Error occurred while using instantiating: " + converterClass, e);
        }
    }

    public final <E> E deserialize(String str, Class<E> type) {
        return this.deserialize(str, type, new ArrayList(0));
    }

    public final <E> E deserialize(String str, Class<E> type, Class<? extends Converter<?>> converterClass) {
        ArrayList col = new ArrayList();
        if (converterClass != null) {
            col.add(converterClass);
        }
        return this.deserialize(str, type, col);
    }

    public final <E> E deserialize(String str, Class<E> type, Collection<Class<? extends Converter<?>>> converterClasses) {
        Convertable convertable;
        logger.debug("deserialize(\"{}\", {})", (Object)str, type);
        DelegatingConverter delegatingConverter = new DelegatingConverter();
        if (converterClasses != null) {
            for (Class<Converter<?>> clazz : converterClasses) {
                delegatingConverter.addConverter(this.createConverter(clazz));
            }
        }
        if ((convertable = ReflectionUtils.getAnnotation(type, Convertable.class)) != null) {
            Class clazz = convertable.value();
            delegatingConverter.addConverter(this.createConverter(clazz));
        }
        delegatingConverter.addConverter(new ConfigurationItemConverter());
        delegatingConverter.addConverter(this.getResourceConverter());
        delegatingConverter.addConverter(new StandardTypeConverter(delegatingConverter));
        delegatingConverter.initializeAll(this._injectionManager);
        Object object = delegatingConverter.fromString(type, str);
        return (E)object;
    }
}

