/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.util.sort;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eobjects.analyzer.util.ImmutableEntry;
import org.eobjects.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SortMergeWriter<R extends Serializable, W extends Closeable> {
    private static final Logger logger = LoggerFactory.getLogger(SortMergeWriter.class);
    private final int _bufferSize;
    private final Comparator<? super R> _comparator;
    private final List<File> _tempFiles;
    private final Map<R, Integer> _buffer;
    private int _nullCount;

    public SortMergeWriter(Comparator<? super R> comparator) {
        this(50000, comparator);
    }

    public SortMergeWriter(int bufferSize, Comparator<? super R> comparator) {
        this._bufferSize = bufferSize;
        this._tempFiles = new ArrayList<File>();
        this._buffer = new TreeMap<R, Integer>(comparator);
        this._comparator = comparator;
    }

    public void append(R line) {
        this.append(line, 1);
    }

    public void append(R line, int frequency) {
        if (line == null) {
            this._nullCount += frequency;
        } else {
            Integer count = this._buffer.get(line);
            if (count == null) {
                if (this._buffer.size() == this._bufferSize) {
                    this.flushBuffer();
                }
                count = 0;
            }
            count = count + frequency;
            this._buffer.put(line, count);
        }
    }

    private void flushBuffer() {
        logger.debug("flushBuffer()");
        ObjectOutputStream oos = null;
        try {
            File file = this.createTempFile();
            logger.info("Writing {} rows to temporary file: {}", (Object)this._bufferSize, (Object)file);
            oos = new ObjectOutputStream(new FileOutputStream(file));
            Set<Map.Entry<R, Integer>> entries = this._buffer.entrySet();
            for (Map.Entry<R, Integer> entry : entries) {
                oos.writeObject(entry.getKey());
                oos.writeInt(entry.getValue());
            }
            this._buffer.clear();
            this._tempFiles.add(file);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{oos});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{oos});
    }

    protected File createTempFile() throws IOException {
        File file = File.createTempFile("sort_merge", ".dat");
        file.deleteOnExit();
        return file;
    }

    protected boolean writeNullsFirst() {
        return true;
    }

    protected abstract void writeHeader(W var1) throws IOException;

    protected abstract void writeRow(W var1, R var2, int var3) throws IOException;

    protected abstract W createWriter(File var1);

    protected void writeNull(W writer, int nullCount) throws IOException {
        this.writeRow(writer, null, nullCount);
    }

    public File write(String filename) {
        File file = new File(filename);
        this.write(file);
        return file;
    }

    public int write(File file) {
        int n;
        boolean writeNullsFirst;
        int rowCount;
        ObjectInputStream[] tempFileObjectInputStreams;
        W writer;
        block21: {
            writer = null;
            tempFileObjectInputStreams = null;
            writer = this.createWriter(file);
            this.writeHeader(writer);
            rowCount = 0;
            writeNullsFirst = this.writeNullsFirst();
            if (this._nullCount > 0 && writeNullsFirst) {
                this.writeNull(writer, this._nullCount);
                ++rowCount;
            }
            if (!this._tempFiles.isEmpty()) break block21;
            logger.info("No temp files created yet, flushing buffer directly to target file: {}", (Object)file);
            Set<Map.Entry<R, Integer>> entries = this._buffer.entrySet();
            for (Map.Entry<R, Integer> entry : entries) {
                this.writeRow(writer, (Serializable)entry.getKey(), entry.getValue());
                ++rowCount;
            }
            this._buffer.clear();
            if (this._nullCount > 0 && !writeNullsFirst) {
                this.writeNull(writer, this._nullCount);
                ++rowCount;
            }
            int i$ = rowCount;
            FileHelper.safeClose((Object[])new Object[]{writer});
            if (tempFileObjectInputStreams != null) {
                for (int i = 0; i < tempFileObjectInputStreams.length; ++i) {
                    FileHelper.safeClose((Object[])new Object[]{tempFileObjectInputStreams[i]});
                }
            }
            return i$;
        }
        try {
            if (!this._buffer.isEmpty()) {
                this.flushBuffer();
            }
            tempFileObjectInputStreams = this.createTempFileObjectInputStreams();
            ArrayList<Map.Entry<R, Integer>> rowCandidates = new ArrayList<Map.Entry<R, Integer>>(this._tempFiles.size());
            for (int i = 0; i < this._tempFiles.size(); ++i) {
                rowCandidates.add(null);
            }
            while (true) {
                this.readNextRows(rowCandidates, tempFileObjectInputStreams);
                Map.Entry currentRow = null;
                for (Map.Entry entry : rowCandidates) {
                    if (entry == null) continue;
                    if (currentRow == null) {
                        currentRow = entry;
                        continue;
                    }
                    if (this._comparator.compare(entry.getKey(), currentRow.getKey()) >= 0) continue;
                    currentRow = entry;
                }
                if (currentRow == null) break;
                currentRow = new ImmutableEntry(currentRow.getKey(), 0);
                for (int i = 0; i < rowCandidates.size(); ++i) {
                    Map.Entry entry = (Map.Entry)rowCandidates.get(i);
                    if (entry == null || this._comparator.compare(entry.getKey(), currentRow.getKey()) != 0) continue;
                    int newCount = currentRow.getValue() + (Integer)entry.getValue();
                    currentRow = new ImmutableEntry(currentRow.getKey(), newCount);
                    rowCandidates.set(i, null);
                }
                this.writeRow(writer, (Serializable)currentRow.getKey(), currentRow.getValue());
                ++rowCount;
            }
            if (this._nullCount > 0 && !writeNullsFirst) {
                this.writeNull(writer, this._nullCount);
                ++rowCount;
            }
            n = rowCount;
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{writer});
                if (tempFileObjectInputStreams != null) {
                    for (int i = 0; i < tempFileObjectInputStreams.length; ++i) {
                        FileHelper.safeClose((Object[])new Object[]{tempFileObjectInputStreams[i]});
                    }
                }
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{writer});
        if (tempFileObjectInputStreams != null) {
            for (int i = 0; i < tempFileObjectInputStreams.length; ++i) {
                FileHelper.safeClose((Object[])new Object[]{tempFileObjectInputStreams[i]});
            }
        }
        return n;
    }

    private void readNextRows(List<Map.Entry<R, Integer>> nextRows, ObjectInputStream[] tempFileObjectInputStreams) throws Exception {
        for (int i = 0; i < tempFileObjectInputStreams.length; ++i) {
            if (tempFileObjectInputStreams[i] == null || nextRows.get(i) != null) continue;
            try {
                Serializable row = (Serializable)tempFileObjectInputStreams[i].readObject();
                int count = tempFileObjectInputStreams[i].readInt();
                ImmutableEntry<Serializable, Integer> entry = new ImmutableEntry<Serializable, Integer>(row, count);
                nextRows.set(i, entry);
                continue;
            }
            catch (EOFException e) {
                FileHelper.safeClose((Object[])new Object[]{tempFileObjectInputStreams[i]});
                tempFileObjectInputStreams[i] = null;
            }
        }
    }

    private ObjectInputStream[] createTempFileObjectInputStreams() throws IOException {
        ObjectInputStream[] tempFileObjectInputStreams = new ObjectInputStream[this._tempFiles.size()];
        for (int i = 0; i < tempFileObjectInputStreams.length; ++i) {
            ObjectInputStream ois;
            File tempFile = this._tempFiles.get(i);
            tempFileObjectInputStreams[i] = ois = new ObjectInputStream(new FileInputStream(tempFile));
        }
        return tempFileObjectInputStreams;
    }
}

