/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.datastructures;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Alias;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.DataStructuresCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformerBean(value="Build key/value map")
@Alias(value={"Build map"})
@Description(value="Build a map with a variable amount of keys and values. Adds the capability to store complex structures with named entries within it.")
@Categorized(value={DataStructuresCategory.class})
public class BuildMapTransformer
implements Transformer<Map<String, ?>> {
    private static final Logger logger = LoggerFactory.getLogger(BuildMapTransformer.class);
    @Inject
    @Configured
    InputColumn<?>[] values;
    @Inject
    @Configured
    String[] keys;
    @Inject
    @Configured
    boolean retainKeyOrder = false;
    @Inject
    @Configured
    boolean includeNullValues = false;
    @Inject
    @Configured(required=false)
    @Description(value="Add key/value pairs to this (optional) existing map")
    InputColumn<Map<String, Object>> addToExistingMap;

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public void setRetainKeyOrder(boolean retainKeyOrder) {
        this.retainKeyOrder = retainKeyOrder;
    }

    public void setValues(InputColumn<?>[] values) {
        this.values = values;
    }

    public OutputColumns getOutputColumns() {
        StringBuilder sb = new StringBuilder("Map: ");
        for (int i = 0; i < this.keys.length; ++i) {
            String key = this.keys[i];
            sb.append(key);
            if (sb.length() > 30) {
                sb.append("...");
                break;
            }
            if (i + 1 >= this.keys.length) continue;
            sb.append(",");
        }
        OutputColumns outputColumns = new OutputColumns(new String[]{sb.toString()}, new Class[]{Map.class});
        return outputColumns;
    }

    public Map<String, ?>[] transform(InputRow row) {
        Map existingMap = this.addToExistingMap != null ? (Map)row.getValue(this.addToExistingMap) : Collections.emptyMap();
        HashMap map = this.retainKeyOrder ? new LinkedHashMap(existingMap) : new HashMap(existingMap);
        for (int i = 0; i < this.keys.length; ++i) {
            String key = this.keys[i];
            Object value = row.getValue(this.values[i]);
            if (value == null && !this.includeNullValues) {
                logger.debug("Ignoring null value for {} in row: {}", (Object)key, (Object)row);
                continue;
            }
            map.put(key, value);
        }
        Map[] result = new Map[]{map};
        return result;
    }
}

