/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.datastructures;

import java.util.List;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.OutputRowCollector;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.DataStructuresCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Read elements from list")
@Description(value="Reads all elements of a list, creating a record for each value")
@Categorized(value={DataStructuresCategory.class})
public class ReadFromListTransformer
implements Transformer<Object> {
    @Inject
    @Configured
    InputColumn<List<?>> listColumn;
    @Inject
    @Configured
    Class<?> elementType;
    @Inject
    @Configured
    @Description(value="Verify that expected element type and actual type are the same")
    boolean verifyTypes = false;
    @Inject
    @Provided
    OutputRowCollector outputRowCollector;

    public void setElementType(Class<?> elementType) {
        this.elementType = elementType;
    }

    public void setListColumn(InputColumn<List<?>> listColumn) {
        this.listColumn = listColumn;
    }

    public void setVerifyTypes(boolean verifyTypes) {
        this.verifyTypes = verifyTypes;
    }

    public OutputColumns getOutputColumns() {
        String[] columnNames = new String[]{this.listColumn.getName() + " (element)"};
        Class[] columnTypes = new Class[]{this.elementType};
        return new OutputColumns(columnNames, columnTypes);
    }

    public Object[] transform(InputRow row) {
        List list = (List)row.getValue(this.listColumn);
        if (list == null || list.isEmpty()) {
            return new Object[1];
        }
        for (Object value : list) {
            if (this.verifyTypes) {
                value = this.elementType.cast(value);
            }
            this.outputRowCollector.putValues(new Object[]{value});
        }
        return null;
    }
}

