/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.datastructures;

import java.util.Map;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.OutputRowCollector;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.DataStructuresCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Read keys and values from map")
@Description(value="Reads all key/value pairs of a map, creating a record for each pair")
@Categorized(value={DataStructuresCategory.class})
public class ReadFromMapTransformer
implements Transformer<Object> {
    @Inject
    @Configured
    InputColumn<Map<String, ?>> mapColumn;
    @Inject
    @Configured
    @Description(value="Expected type of the values")
    Class<?> valueType;
    @Inject
    @Configured
    @Description(value="Verify that expected value type and actual type are the same")
    boolean verifyTypes = false;
    @Inject
    @Provided
    OutputRowCollector outputRowCollector;

    public OutputColumns getOutputColumns() {
        String[] columnNames = new String[]{this.mapColumn.getName() + " (key)", this.mapColumn.getName() + " (value)"};
        Class[] columnTypes = new Class[]{String.class, this.valueType};
        return new OutputColumns(columnNames, columnTypes);
    }

    public Object[] transform(InputRow row) {
        Map map = (Map)row.getValue(this.mapColumn);
        if (map == null || map.isEmpty()) {
            return new Object[2];
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (this.verifyTypes) {
                value = this.valueType.cast(value);
            }
            this.outputRowCollector.putValues(new Object[]{key, value});
        }
        return null;
    }
}

