/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.datastructures;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.DataStructuresCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Select values from key/value map")
@Description(value="Given a specified list of keys, this transformer will select the values from a key/value map and place them as columns within the record")
@Categorized(value={DataStructuresCategory.class})
public class SelectFromMapTransformer
implements Transformer<Object> {
    @Inject
    @Configured
    InputColumn<Map<String, ?>> mapColumn;
    @Inject
    @Configured
    String[] keys;
    @Inject
    @Configured
    Class<?>[] types;
    @Inject
    @Configured
    @Description(value="Verify that expected type and actual type are the same")
    boolean verifyTypes = false;

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public void setTypes(Class<?>[] types) {
        this.types = types;
    }

    public void setMapColumn(InputColumn<Map<String, ?>> mapColumn) {
        this.mapColumn = mapColumn;
    }

    public void setVerifyTypes(boolean verifyTypes) {
        this.verifyTypes = verifyTypes;
    }

    public OutputColumns getOutputColumns() {
        String[] keys = this.keys;
        Class[] types = this.types;
        if (keys.length != types.length) {
            int length = Math.min(keys.length, types.length);
            keys = Arrays.copyOf(keys, length);
            types = Arrays.copyOf(types, length);
        }
        return new OutputColumns(keys, types);
    }

    public Object[] transform(InputRow row) {
        Map map = (Map)row.getValue(this.mapColumn);
        Object[] result = new Object[this.keys.length];
        if (map == null) {
            return result;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            Object value = SelectFromMapTransformer.find(map, this.keys[i]);
            if (this.verifyTypes) {
                value = this.types[i].cast(value);
            }
            result[i] = value;
        }
        return result;
    }

    public static Object find(Map<String, ?> map, String key) {
        if (map == null || key == null) {
            return null;
        }
        Object result = map.get(key);
        if (result == null) {
            return SelectFromMapTransformer.find(map, key, 0);
        }
        return result;
    }

    private static Object find(Map<String, ?> map, String key, int fromIndex) {
        Object nestedObject;
        String prefix;
        boolean hasBracket;
        int indexOfDot = key.indexOf(46, fromIndex);
        int indexOfBracket = key.indexOf(91, fromIndex);
        int indexOfEndBracket = -1;
        int arrayIndex = -1;
        boolean hasDot = indexOfDot != -1;
        boolean bl = hasBracket = indexOfBracket != -1;
        if (hasBracket) {
            indexOfEndBracket = key.indexOf("].", indexOfBracket);
            boolean bl2 = hasBracket = indexOfEndBracket != -1;
            if (hasBracket) {
                String indexString = key.substring(indexOfBracket + 1, indexOfEndBracket);
                try {
                    arrayIndex = Integer.parseInt(indexString);
                }
                catch (NumberFormatException e) {
                    hasBracket = false;
                }
            }
        }
        if (hasDot && hasBracket) {
            if (indexOfDot > indexOfBracket) {
                hasDot = false;
            } else {
                hasBracket = false;
            }
        }
        if (hasDot) {
            prefix = key.substring(0, indexOfDot);
            nestedObject = map.get(prefix);
            if (nestedObject == null) {
                return SelectFromMapTransformer.find(map, key, indexOfDot + 1);
            }
            if (nestedObject instanceof Map) {
                String remainingPart = key.substring(indexOfDot + 1);
                Map nestedMap = (Map)nestedObject;
                return SelectFromMapTransformer.find(nestedMap, remainingPart);
            }
        }
        if (hasBracket) {
            prefix = key.substring(0, indexOfBracket);
            nestedObject = map.get(prefix);
            if (nestedObject == null) {
                return SelectFromMapTransformer.find(map, key, indexOfBracket + 1);
            }
            String remainingPart = key.substring(indexOfEndBracket + 2);
            try {
                if (nestedObject instanceof List) {
                    Map nestedMap = (Map)((List)nestedObject).get(arrayIndex);
                    return SelectFromMapTransformer.find(nestedMap, remainingPart);
                }
                if (nestedObject.getClass().isArray()) {
                    Map nestedMap = (Map)Array.get(nestedObject, arrayIndex);
                    return SelectFromMapTransformer.find(nestedMap, remainingPart);
                }
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }
}

