/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.dategap;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.categories.DateAndTimeCategory;
import org.eobjects.analyzer.beans.dategap.DateGapAnalyzerResult;
import org.eobjects.analyzer.beans.dategap.TimeInterval;
import org.eobjects.analyzer.beans.dategap.TimeLine;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnalyzerBean(value="Date gap analyzer")
@Description(value="Analyze the periodic gaps between FROM and TO dates.")
@Categorized(value={DateAndTimeCategory.class})
public class DateGapAnalyzer
implements Analyzer<DateGapAnalyzerResult> {
    private static final Logger logger = LoggerFactory.getLogger(DateGapAnalyzer.class);
    @Configured(order=1)
    InputColumn<Date> fromColumn;
    @Configured(order=2)
    InputColumn<Date> toColumn;
    @Configured(order=3, required=false)
    @Description(value="Optional column to group timelines by, if the table contains multiple timelines")
    InputColumn<String> groupColumn;
    @Configured(order=4, required=false, value="Count intersecting from and to dates as overlaps")
    Boolean singleDateOverlaps = false;
    @Configured(order=5, value="Fault tolerant switch from/to dates", required=false)
    @Description(value="Turn on/off automatic switching of FROM and TO dates, if FROM has a higher value than TO.")
    boolean faultTolerantDateSwitch = true;
    private final Map<String, TimeLine> timelines = new HashMap<String, TimeLine>();

    public DateGapAnalyzer() {
    }

    public DateGapAnalyzer(InputColumn<Date> fromColumn, InputColumn<Date> toColumn, InputColumn<String> groupColumn) {
        this.fromColumn = fromColumn;
        this.toColumn = toColumn;
        this.groupColumn = groupColumn;
    }

    public void run(InputRow row, int distinctCount) {
        Date from = (Date)row.getValue(this.fromColumn);
        Date to = (Date)row.getValue(this.toColumn);
        if (from != null && to != null) {
            String groupName = null;
            if (this.groupColumn != null) {
                groupName = (String)row.getValue(this.groupColumn);
            }
            if (this.faultTolerantDateSwitch && from.compareTo(to) > 0) {
                logger.info("Switching around from and to, because {} is higher than {} (row: {})", new Object[]{from, to, row});
                this.put(groupName, new TimeInterval(to, from));
            } else {
                this.put(groupName, new TimeInterval(from, to));
            }
        } else {
            logger.info("Encountered row where from column or to column was null, ignoring");
        }
    }

    protected void put(String groupName, TimeInterval interval) {
        TimeLine timeline = this.timelines.get(groupName);
        if (timeline == null) {
            timeline = new TimeLine();
            this.timelines.put(groupName, timeline);
        }
        timeline.addInterval(interval);
    }

    public DateGapAnalyzerResult getResult() {
        boolean includeSingleTimeInstanceIntervals = false;
        if (this.singleDateOverlaps != null) {
            includeSingleTimeInstanceIntervals = this.singleDateOverlaps;
        }
        HashMap<String, TimeInterval> completeIntervals = new HashMap<String, TimeInterval>();
        HashMap<String, SortedSet<TimeInterval>> gaps = new HashMap<String, SortedSet<TimeInterval>>();
        HashMap<String, SortedSet<TimeInterval>> overlaps = new HashMap<String, SortedSet<TimeInterval>>();
        Set<String> groupNames = this.timelines.keySet();
        for (String name : groupNames) {
            TimeLine timeline = this.timelines.get(name);
            SortedSet<TimeInterval> timelineGaps = timeline.getTimeGapIntervals();
            SortedSet<TimeInterval> timelineOverlaps = timeline.getOverlappingIntervals(includeSingleTimeInstanceIntervals);
            completeIntervals.put(name, new TimeInterval(timeline.getFrom(), timeline.getTo()));
            gaps.put(name, timelineGaps);
            overlaps.put(name, timelineOverlaps);
        }
        String groupColumnName = this.groupColumn == null ? null : this.groupColumn.getName();
        return new DateGapAnalyzerResult(this.fromColumn.getName(), this.toColumn.getName(), groupColumnName, completeIntervals, gaps, overlaps);
    }

    public void setFromColumn(InputColumn<Date> fromColumn) {
        this.fromColumn = fromColumn;
    }

    public void setGroupColumn(InputColumn<String> groupColumn) {
        this.groupColumn = groupColumn;
    }

    public void setSingleDateOverlaps(Boolean singleDateOverlaps) {
        this.singleDateOverlaps = singleDateOverlaps;
    }

    public void setToColumn(InputColumn<Date> toColumn) {
        this.toColumn = toColumn;
    }
}

