/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.dategap;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import org.eobjects.analyzer.beans.api.ParameterizableMetric;
import org.eobjects.analyzer.beans.dategap.TimeInterval;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.result.Metric;

public class DateGapAnalyzerResult
implements AnalyzerResult {
    private static final long serialVersionUID = 1L;
    private final String _fromColumnName;
    private final String _toColumnName;
    private final String _groupColumnName;
    private final Map<String, SortedSet<TimeInterval>> _gaps;
    private final Map<String, SortedSet<TimeInterval>> _overlaps;
    private final Map<String, TimeInterval> _completeDurations;

    public DateGapAnalyzerResult(String fromColumnName, String toColumnName, String groupColumnName, Map<String, TimeInterval> completeIntervals, Map<String, SortedSet<TimeInterval>> gaps, Map<String, SortedSet<TimeInterval>> overlaps) {
        this._fromColumnName = fromColumnName;
        this._toColumnName = toColumnName;
        this._groupColumnName = groupColumnName;
        this._completeDurations = completeIntervals;
        this._gaps = gaps;
        this._overlaps = overlaps;
    }

    public Set<String> getGroupNames() {
        return this._gaps.keySet();
    }

    @Metric(value="Total date gap count")
    public int getTotalGapCount() {
        int count = 0;
        Collection<SortedSet<TimeInterval>> gapSets = this._gaps.values();
        for (SortedSet<TimeInterval> gapSet : gapSets) {
            count += gapSet.size();
        }
        return count;
    }

    @Metric(value="Date gap count")
    public ParameterizableMetric getGapCount() {
        return new ParameterizableMetric(){

            public Number getValue(String parameter) {
                SortedSet gapSet = (SortedSet)DateGapAnalyzerResult.this._gaps.get(parameter);
                if (gapSet == null) {
                    return 0;
                }
                return gapSet.size();
            }

            public Collection<String> getParameterSuggestions() {
                return DateGapAnalyzerResult.this._gaps.keySet();
            }
        };
    }

    public TimeInterval getCompleteDuration(String groupName) {
        return this._completeDurations.get(groupName);
    }

    public SortedSet<TimeInterval> getGaps(String groupName) {
        return this._gaps.get(groupName);
    }

    public SortedSet<TimeInterval> getOverlaps(String groupName) {
        return this._overlaps.get(groupName);
    }

    public String getFromColumnName() {
        return this._fromColumnName;
    }

    public String getToColumnName() {
        return this._toColumnName;
    }

    public String getGroupColumnName() {
        return this._groupColumnName;
    }

    public String toString() {
        return "DateGapAnalyzerResult[gaps=" + new TreeMap<String, SortedSet<TimeInterval>>(this._gaps) + "]";
    }
}

