/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.dategap;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.SortedSet;
import org.eobjects.analyzer.beans.api.RendererBean;
import org.eobjects.analyzer.beans.dategap.DateGapAnalyzerResult;
import org.eobjects.analyzer.beans.dategap.TimeInterval;
import org.eobjects.analyzer.result.renderer.AbstractRenderer;
import org.eobjects.analyzer.result.renderer.TextRenderingFormat;
import org.eobjects.analyzer.util.StringUtils;

@RendererBean(value=TextRenderingFormat.class)
public class DateGapTextRenderer
extends AbstractRenderer<DateGapAnalyzerResult, String> {
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    public String render(DateGapAnalyzerResult result) {
        Set<String> names = result.getGroupNames();
        if (names.isEmpty()) {
            return "No timelines recorded";
        }
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            SortedSet<TimeInterval> gaps;
            if (!StringUtils.isNullOrEmpty((String)name)) {
                sb.append("Timeline recorded for '");
                sb.append(name);
                sb.append('\'');
                sb.append('\n');
            }
            if ((gaps = result.getGaps(name)).isEmpty()) {
                sb.append(" - no time gaps!\n");
            } else {
                for (TimeInterval timeInterval : gaps) {
                    sb.append(" - time gap: ");
                    sb.append(this.format(timeInterval));
                    sb.append('\n');
                }
            }
            SortedSet<TimeInterval> overlaps = result.getOverlaps(name);
            if (overlaps.isEmpty()) {
                sb.append(" - no time overlaps!\n");
                continue;
            }
            for (TimeInterval timeInterval : overlaps) {
                sb.append(" - time overlap: ");
                sb.append(this.format(timeInterval));
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    private String format(TimeInterval interval) {
        Date from = new Date(interval.getFrom());
        Date to = new Date(interval.getTo());
        return this.df.format(from) + " to " + this.df.format(to);
    }
}

