/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.dategap;

import java.io.Serializable;
import java.util.Date;
import org.eobjects.analyzer.util.CompareUtils;

public class TimeInterval
implements Serializable,
Comparable<TimeInterval>,
Cloneable {
    private static final long serialVersionUID = 1L;
    private long _from;
    private long _to;

    public static TimeInterval merge(TimeInterval o1, TimeInterval o2) {
        long from = Math.min(o1.getFrom(), o2.getFrom());
        long to = Math.max(o1.getTo(), o2.getTo());
        return new TimeInterval(from, to);
    }

    public TimeInterval(Date from, Date to) {
        if (from == null) {
            throw new IllegalArgumentException("from cannot be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("to cannot be null");
        }
        this._from = from.getTime();
        this._to = to.getTime();
    }

    public TimeInterval(long from, long to) {
        this._from = from;
        this._to = to;
    }

    public boolean before(TimeInterval o) {
        return this.compareTo(o) < 0;
    }

    public boolean after(TimeInterval o) {
        return this.compareTo(o) > 0;
    }

    public long getFrom() {
        return this._from;
    }

    public long getTo() {
        return this._to;
    }

    @Override
    public int compareTo(TimeInterval o) {
        int diff = CompareUtils.compare((Comparable)Long.valueOf(this.getFrom()), (Object)o.getFrom());
        if (diff == 0) {
            diff = CompareUtils.compare((Comparable)Long.valueOf(this.getTo()), (Object)o.getTo());
        }
        return diff;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this._from ^ this._from >>> 32);
        result = 31 * result + (int)(this._to ^ this._to >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeInterval other = (TimeInterval)obj;
        if (this._from != other._from) {
            return false;
        }
        return this._to == other._to;
    }

    public String toString() {
        return "TimeInterval[" + this.getFrom() + "->" + this.getTo() + "]";
    }

    public TimeInterval clone() {
        try {
            return (TimeInterval)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed.");
        }
    }

    public boolean overlapsWith(TimeInterval interval) {
        return this.getOverlap(interval) != null;
    }

    public TimeInterval getOverlap(TimeInterval interval) {
        long minimumTo;
        long from = interval.getFrom();
        long to = interval.getTo();
        long maximumFrom = Math.max(this._from, from);
        if (maximumFrom <= (minimumTo = Math.min(this._to, to))) {
            return new TimeInterval(maximumFrom, minimumTo);
        }
        return null;
    }

    public boolean isSingleTimeInstance() {
        return this._from == this._to;
    }
}

