/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.dategap;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eobjects.analyzer.beans.dategap.TimeInterval;

public class TimeLine
implements Serializable {
    private static final long serialVersionUID = 1L;
    private NavigableSet<TimeInterval> intervals = new TreeSet<TimeInterval>();

    public void addInterval(TimeInterval i) {
        this.intervals.add(i);
    }

    public SortedSet<TimeInterval> getIntervals() {
        return Collections.unmodifiableSortedSet(this.intervals);
    }

    public SortedSet<TimeInterval> getFlattenedIntervals() {
        return this.getFlattenedIntervals(this.intervals);
    }

    private SortedSet<TimeInterval> getFlattenedIntervals(SortedSet<TimeInterval> intervals) {
        TreeSet<TimeInterval> result = new TreeSet<TimeInterval>();
        for (TimeInterval interval : intervals) {
            Iterator it = result.iterator();
            while (it.hasNext()) {
                TimeInterval ti = (TimeInterval)it.next();
                if (!ti.overlapsWith(interval)) continue;
                it.remove();
                interval = TimeInterval.merge(ti, interval);
            }
            result.add(interval);
        }
        return result;
    }

    public SortedSet<TimeInterval> getOverlappingIntervals(boolean includeSingleTimeInstanceIntervals) {
        SortedSet<TimeInterval> result = new TreeSet<TimeInterval>();
        for (TimeInterval interval1 : this.intervals) {
            for (TimeInterval interval2 : this.intervals) {
                TimeInterval overlap;
                if (interval1 == interval2 || (overlap = interval1.getOverlap(interval2)) == null) continue;
                result.add(overlap);
            }
        }
        result = this.getFlattenedIntervals(result);
        if (!includeSingleTimeInstanceIntervals) {
            Iterator it = result.iterator();
            while (it.hasNext()) {
                TimeInterval timeInterval = (TimeInterval)it.next();
                if (!timeInterval.isSingleTimeInstance()) continue;
                it.remove();
            }
        }
        return result;
    }

    public SortedSet<TimeInterval> getTimeGapIntervals() {
        SortedSet<TimeInterval> flattenedIntervals = this.getFlattenedIntervals();
        TreeSet<TimeInterval> gaps = new TreeSet<TimeInterval>();
        TimeInterval previous = null;
        for (TimeInterval timeInterval : flattenedIntervals) {
            if (previous != null) {
                long from = previous.getTo();
                long to = timeInterval.getFrom();
                TimeInterval gap = new TimeInterval(from, to);
                gaps.add(gap);
            }
            previous = timeInterval;
        }
        return gaps;
    }

    public Date getFrom() {
        TimeInterval first = (TimeInterval)this.intervals.first();
        if (first != null) {
            return new Date(first.getFrom());
        }
        return null;
    }

    public Date getTo() {
        Long to = null;
        for (TimeInterval interval : this.intervals) {
            if (to == null) {
                to = interval.getTo();
                continue;
            }
            to = Math.max(interval.getTo(), to);
        }
        if (to != null) {
            return new Date(to);
        }
        return null;
    }
}

