/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import com.ibm.icu.text.UnicodeSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;
import org.eobjects.analyzer.util.CharIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CharacterSetDistributionAnalyzerColumnDelegate {
    private static final Logger logger = LoggerFactory.getLogger(CharacterSetDistributionAnalyzerColumnDelegate.class);
    private final RowAnnotationFactory _annotationFactory;
    private final Map<String, UnicodeSet> _unicodeSets;
    private final Map<String, RowAnnotation> _annotations;

    public CharacterSetDistributionAnalyzerColumnDelegate(RowAnnotationFactory annotationFactory, Map<String, UnicodeSet> unicodeSets) {
        this._annotationFactory = annotationFactory;
        this._unicodeSets = unicodeSets;
        this._annotations = new HashMap<String, RowAnnotation>();
        for (String name : unicodeSets.keySet()) {
            this._annotations.put(name, this._annotationFactory.createAnnotation());
        }
    }

    public RowAnnotation getAnnotation(String unicodeSetName) {
        return this._annotations.get(unicodeSetName);
    }

    public synchronized void run(String value, InputRow row, int distinctCount) {
        ArrayList<Map.Entry<String, UnicodeSet>> unicodeSetsRemaining = new ArrayList<Map.Entry<String, UnicodeSet>>(this._unicodeSets.entrySet());
        CharIterator charIterator = new CharIterator((CharSequence)value);
        while (charIterator.hasNext()) {
            Character c = charIterator.next();
            if (charIterator.isWhitespace() || charIterator.isDigit()) {
                logger.debug("Skipping whitespace/digit char: {}", (Object)c);
                continue;
            }
            Iterator it = unicodeSetsRemaining.iterator();
            while (it.hasNext()) {
                Map.Entry unicodeSet = (Map.Entry)it.next();
                if (!((UnicodeSet)unicodeSet.getValue()).contains((int)c.charValue())) continue;
                String name = (String)unicodeSet.getKey();
                RowAnnotation annotation = this._annotations.get(name);
                this._annotationFactory.annotate(row, distinctCount, annotation);
                it.remove();
            }
        }
    }
}

