/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import com.ibm.icu.text.Transliterator;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.StringManipulationCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Transliterate")
@Description(value="Converts non-latin characters to latin (or even ASCII) characters.")
@Categorized(value={StringManipulationCategory.class})
public class TransliterateTransformer
implements Transformer<String> {
    @Configured
    InputColumn<String> column;
    @Configured(required=false)
    @Description(value="Should latin characters and diacritics be converted to plain ASCII?")
    boolean latinToAscii = true;
    private final Transliterator latinTransliterator = Transliterator.getInstance((String)"Any-Latin");
    private final Transliterator asciiTransformer = Transliterator.getInstance((String)"Latin-ASCII");

    public OutputColumns getOutputColumns() {
        return new OutputColumns(this.column.getName() + " (transliterated)", new String[0]);
    }

    public String[] transform(InputRow inputRow) {
        String value = (String)inputRow.getValue(this.column);
        if (value == null) {
            return new String[1];
        }
        value = this.latinTransliterator.transform(value);
        if (this.latinToAscii) {
            value = this.asciiTransformer.transform(value);
        }
        return new String[]{value};
    }
}

