/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.result;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.eobjects.analyzer.beans.api.Distributed;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.result.CharacterSetDistributionResultReducer;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabResult;

@Distributed(reducer=CharacterSetDistributionResultReducer.class)
public class CharacterSetDistributionResult
extends CrosstabResult {
    private static final long serialVersionUID = 1L;
    private final InputColumn<String>[] _columns;
    private final Set<String> _unicodeSetNames;

    public CharacterSetDistributionResult(InputColumn<String>[] columns, String[] unicodeSetNames, Crosstab<Number> crosstab) {
        super(crosstab);
        this._columns = columns;
        this._unicodeSetNames = new TreeSet<String>();
        for (String unicodeSetName : unicodeSetNames) {
            this._unicodeSetNames.add(unicodeSetName);
        }
    }

    public CharacterSetDistributionResult(InputColumn<String>[] columns, Collection<String> unicodeSetNames, Crosstab<Number> crosstab) {
        super(crosstab);
        this._columns = columns;
        this._unicodeSetNames = new TreeSet<String>(unicodeSetNames);
    }

    public InputColumn<String>[] getColumns() {
        return Arrays.copyOf(this._columns, this._columns.length);
    }

    public String[] getUnicodeSetNames() {
        return this._unicodeSetNames.toArray(new String[this._unicodeSetNames.size()]);
    }
}

