/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.result;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.result.AbstractCrosstabResultReducer;
import org.eobjects.analyzer.result.CharacterSetDistributionResult;
import org.eobjects.analyzer.result.Crosstab;

public class CharacterSetDistributionResultReducer
extends AbstractCrosstabResultReducer<CharacterSetDistributionResult> {
    protected Serializable reduceValues(List<Object> slaveValues, String category1, String category2, Collection<? extends CharacterSetDistributionResult> results, Class<?> valueClass) {
        int sum = 0;
        for (Object slaveValue : slaveValues) {
            sum += ((Number)slaveValue).intValue();
        }
        return Integer.valueOf(sum);
    }

    protected CharacterSetDistributionResult buildResult(Crosstab<?> crosstab, Collection<? extends CharacterSetDistributionResult> results) {
        CharacterSetDistributionResult firstResult = results.iterator().next();
        InputColumn<String>[] columns = firstResult.getColumns();
        String[] unicodeSetNames = firstResult.getUnicodeSetNames();
        return new CharacterSetDistributionResult(columns, unicodeSetNames, crosstab);
    }
}

