/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.script;

import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Close;
import org.eobjects.analyzer.beans.api.Concurrent;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.OutputRowCollector;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.beans.api.StringProperty;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.ScriptingCategory;
import org.eobjects.analyzer.beans.script.JavaScriptUtils;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformerBean(value="JavaScript transformer (advanced)")
@Description(value="Supply your own piece of JavaScript to do a custom transformation")
@Categorized(value={ScriptingCategory.class})
@Concurrent(value=false)
public class JavaScriptAdvancedTransformer
implements Transformer<Object> {
    private static final Logger logger = LoggerFactory.getLogger(JavaScriptAdvancedTransformer.class);
    @Inject
    @Configured
    InputColumn<?>[] columns;
    @Inject
    @Configured
    Class<?>[] returnTypes = new Class[]{String.class, Object.class};
    @Inject
    @Configured
    @StringProperty(multiline=true, mimeType={"text/javascript", "application/x-javascript"})
    String sourceCode = "var transformerObj = {\n\tinitialize: function() {\n\t\tlogger.info('Initializing advanced JavaScript transformer...');\n\t},\n\n\ttransform: function(columns,values,outputCollector) {\n\t\tlogger.debug('transform({},{},{}) invoked', columns, values, outputCollector);\n\t\tfor (var i=0;i<columns.length;i++) {\n\t\t\toutputCollector.putValues(columns[i],values[i])\n\t\t}\n\t},\n\n\tclose: function() {\n\t\tlogger.info('Closing advanced JavaScript transformer...');\n\t}\n}";
    @Inject
    @Provided
    OutputRowCollector rowCollector;
    private ContextFactory _contextFactory;
    private Script _script;
    private ScriptableObject _sharedScope;
    private NativeObject _transformerObj;
    private Function _initializeFunction;
    private Function _transformFunction;
    private Function _closeFunction;

    public OutputColumns getOutputColumns() {
        String[] names = new String[this.returnTypes.length];
        Class[] types = new Class[this.returnTypes.length];
        for (int i = 0; i < this.returnTypes.length; ++i) {
            names[i] = "JavaScript output " + (i + 1);
            types[i] = this.returnTypes[i];
        }
        OutputColumns outputColumns = new OutputColumns(names, types);
        return outputColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initialize
    public void init() {
        this._contextFactory = new ContextFactory();
        Context context = this._contextFactory.enterContext();
        try {
            this._script = context.compileString(this.sourceCode, this.getClass().getSimpleName(), 1, null);
            this._sharedScope = context.initStandardObjects();
            JavaScriptUtils.addToScope((Scriptable)this._sharedScope, logger, "logger", "log");
            JavaScriptUtils.addToScope((Scriptable)this._sharedScope, System.out, "out");
            this._script.exec(context, (Scriptable)this._sharedScope);
            this._transformerObj = (NativeObject)this._sharedScope.get((Object)"transformerObj");
            if (this._transformerObj == null) {
                throw new IllegalStateException("Required JS object 'transformerObj' not found!");
            }
            this._initializeFunction = (Function)this._transformerObj.get((Object)"initialize");
            this._transformFunction = (Function)this._transformerObj.get((Object)"transform");
            this._closeFunction = (Function)this._transformerObj.get((Object)"close");
            this._initializeFunction.call(context, (Scriptable)this._sharedScope, (Scriptable)this._sharedScope, new Object[0]);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Close
    public void close() {
        Context context = this._contextFactory.enterContext();
        try {
            this._closeFunction.call(context, (Scriptable)this._sharedScope, (Scriptable)this._sharedScope, new Object[0]);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] transform(InputRow inputRow) {
        Context context = this._contextFactory.enterContext();
        try {
            String[] columnNames = new String[this.columns.length];
            Object[] values = new Object[this.columns.length];
            for (int i = 0; i < this.columns.length; ++i) {
                columnNames[i] = this.columns[i].getName();
                values[i] = inputRow.getValue(this.columns[i]);
            }
            Object[] args = new Object[]{columnNames, values, this.rowCollector};
            this._transformFunction.call(context, (Scriptable)this._sharedScope, (Scriptable)this._sharedScope, args);
            Object[] objectArray = null;
            return objectArray;
        }
        finally {
            Context.exit();
        }
    }
}

