/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.stringpattern;

import java.util.HashMap;
import java.util.Map;
import org.eobjects.analyzer.beans.stringpattern.PatternFinder;
import org.eobjects.analyzer.beans.stringpattern.TokenPattern;
import org.eobjects.analyzer.beans.stringpattern.TokenizerConfiguration;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.storage.InMemoryRowAnnotationFactory;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;

public final class DefaultPatternFinder
extends PatternFinder<InputRow> {
    private final Map<TokenPattern, RowAnnotation> _annotations;
    private final RowAnnotationFactory _annotationFactory;

    public DefaultPatternFinder(TokenizerConfiguration configuration, RowAnnotationFactory annotationFactory) {
        super(configuration);
        if (annotationFactory == null) {
            throw new IllegalArgumentException("RowAnnotationFactory cannot be null");
        }
        this._annotations = new HashMap<TokenPattern, RowAnnotation>();
        this._annotationFactory = annotationFactory;
    }

    public DefaultPatternFinder(TokenizerConfiguration configuration, int inMemoryRowThreshold) {
        super(configuration);
        this._annotations = new HashMap<TokenPattern, RowAnnotation>();
        this._annotationFactory = new InMemoryRowAnnotationFactory(inMemoryRowThreshold);
    }

    @Override
    protected void storeNewPattern(TokenPattern pattern, InputRow row, String value, int distinctCount) {
        RowAnnotation annotation = this._annotationFactory.createAnnotation();
        this._annotations.put(pattern, annotation);
        this._annotationFactory.annotate(row, distinctCount, annotation);
    }

    @Override
    protected void storeMatch(TokenPattern pattern, InputRow row, String value, int distinctCount) {
        RowAnnotation annotation = this._annotations.get(pattern);
        if (annotation == null) {
            throw new IllegalStateException("No annotation available for pattern: " + pattern);
        }
        this._annotationFactory.annotate(row, distinctCount, annotation);
    }

    public Map<TokenPattern, RowAnnotation> getAnnotations() {
        return this._annotations;
    }
}

