/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.stringpattern;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eobjects.analyzer.beans.stringpattern.DefaultTokenizer;
import org.eobjects.analyzer.beans.stringpattern.Token;
import org.eobjects.analyzer.beans.stringpattern.TokenPattern;
import org.eobjects.analyzer.beans.stringpattern.TokenPatternImpl;
import org.eobjects.analyzer.beans.stringpattern.Tokenizer;
import org.eobjects.analyzer.beans.stringpattern.TokenizerConfiguration;

public abstract class PatternFinder<R> {
    private final Map<String, Set<TokenPattern>> _patterns;
    private final TokenizerConfiguration _configuration;
    private final Tokenizer _tokenizer;

    public PatternFinder(Tokenizer tokenizer, TokenizerConfiguration configuration) {
        this._configuration = configuration;
        this._tokenizer = tokenizer;
        this._patterns = new HashMap<String, Set<TokenPattern>>();
    }

    public PatternFinder(TokenizerConfiguration configuration) {
        this(new DefaultTokenizer(configuration), configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(R row, String value, int distinctCount) {
        List<Token> tokens;
        boolean match = false;
        try {
            tokens = this._tokenizer.tokenize(value);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Error occurred while tokenizing value: " + value, e);
        }
        String patternCode = this.getPatternCode(tokens);
        PatternFinder patternFinder = this;
        synchronized (patternFinder) {
            Set<TokenPattern> patterns = this._patterns.get(patternCode);
            if (patterns == null) {
                patterns = new HashSet<TokenPattern>();
                this._patterns.put(patternCode, patterns);
            }
            for (TokenPattern pattern : patterns) {
                if (!pattern.match(tokens)) continue;
                this.storeMatch(pattern, row, value, distinctCount);
                match = true;
            }
            if (!match) {
                TokenPatternImpl pattern;
                try {
                    pattern = new TokenPatternImpl(value, tokens, this._configuration);
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Error occurred while creating pattern for: " + tokens, e);
                }
                this.storeNewPattern(pattern, row, value, distinctCount);
                patterns.add(pattern);
            }
        }
    }

    private String getPatternCode(List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        sb.append(tokens.size());
        for (Token token : tokens) {
            sb.append(token.getType().ordinal());
        }
        return sb.toString();
    }

    public Set<TokenPattern> getPatterns() {
        HashSet<TokenPattern> result = new HashSet<TokenPattern>();
        Collection<Set<TokenPattern>> values = this._patterns.values();
        for (Set<TokenPattern> set : values) {
            result.addAll(set);
        }
        return result;
    }

    protected abstract void storeNewPattern(TokenPattern var1, R var2, String var3, int var4);

    protected abstract void storeMatch(TokenPattern var1, R var2, String var3, int var4);
}

