/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.stringpattern;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.eobjects.analyzer.beans.stringpattern.PatternFinderAnalyzer;
import org.eobjects.analyzer.beans.stringpattern.PatternFinderResult;
import org.eobjects.analyzer.beans.stringpattern.ReversePatternFinder;
import org.eobjects.analyzer.beans.stringpattern.TokenPattern;
import org.eobjects.analyzer.beans.stringpattern.TokenizerConfiguration;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.result.AnalyzerResultReducer;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabDimension;
import org.eobjects.analyzer.result.CrosstabNavigator;

public class PatternFinderResultReducer
implements AnalyzerResultReducer<PatternFinderResult> {
    public PatternFinderResult reduce(Collection<? extends PatternFinderResult> results) {
        PatternFinderResult firstResult = results.iterator().next();
        InputColumn<String> column = firstResult.getColumn();
        TokenizerConfiguration tokenizerConfiguration = firstResult.getTokenizerConfiguration();
        if (!firstResult.isGroupingEnabled()) {
            ArrayList crosstabs = new ArrayList(results.size());
            for (PatternFinderResult patternFinderResult : results) {
                Crosstab<?> crosstab = patternFinderResult.getSingleCrosstab();
                crosstabs.add(crosstab);
            }
            Crosstab<?> crosstab = this.reduce(crosstabs, tokenizerConfiguration);
            return new PatternFinderResult(column, crosstab, tokenizerConfiguration);
        }
        HashMap groupedCrosstabs = new HashMap();
        for (PatternFinderResult patternFinderResult : results) {
            Set<Map.Entry<String, Crosstab<?>>> entries = patternFinderResult.getGroupedCrosstabs().entrySet();
            for (Map.Entry<String, Crosstab<?>> entry : entries) {
                String group = entry.getKey();
                ArrayList crosstabsInGroup = (ArrayList)groupedCrosstabs.get(group);
                if (crosstabsInGroup == null) {
                    crosstabsInGroup = new ArrayList();
                    groupedCrosstabs.put(group, crosstabsInGroup);
                }
                crosstabsInGroup.add(entry.getValue());
            }
        }
        TreeMap crosstabs = new TreeMap();
        Set set = groupedCrosstabs.entrySet();
        for (Map.Entry entry : set) {
            String group = (String)entry.getKey();
            List crosstabInGroup = (List)entry.getValue();
            Crosstab<?> crosstab = this.reduce(crosstabInGroup, tokenizerConfiguration);
            crosstabs.put(group, crosstab);
        }
        InputColumn<String> groupColumn = firstResult.getGroupColumn();
        return new PatternFinderResult(column, groupColumn, crosstabs, tokenizerConfiguration);
    }

    private Crosstab<?> reduce(List<Crosstab<?>> crosstabs, TokenizerConfiguration tokenizerConfiguration) {
        String sample;
        if (crosstabs.size() == 1) {
            return crosstabs.get(0);
        }
        ReversePatternFinder patternFinder = new ReversePatternFinder(tokenizerConfiguration);
        for (Crosstab<?> crosstab : crosstabs) {
            CrosstabDimension patternDimension = crosstab.getDimension("Pattern");
            List patterns = patternDimension.getCategories();
            for (String pattern : patterns) {
                CrosstabNavigator navigator = crosstab.where("Pattern", pattern);
                Number matchCount = (Number)navigator.where("Measures", "Match count").get();
                sample = (String)((Object)navigator.where("Measures", "Sample").get());
                patternFinder.run(sample, pattern, matchCount.intValue());
            }
        }
        Set<Map.Entry<TokenPattern, AtomicInteger>> entries = patternFinder.getPatternCounts().entrySet();
        TreeSet<Map.Entry<TokenPattern, AtomicInteger>> sortedEntrySet = new TreeSet<Map.Entry<TokenPattern, AtomicInteger>>(new Comparator<Map.Entry<TokenPattern, AtomicInteger>>(){

            @Override
            public int compare(Map.Entry<TokenPattern, AtomicInteger> o1, Map.Entry<TokenPattern, AtomicInteger> o2) {
                int result = o2.getValue().get() - o1.getValue().get();
                if (result == 0) {
                    result = o1.getKey().toSymbolicString().compareTo(o2.getKey().toSymbolicString());
                }
                return result;
            }
        });
        sortedEntrySet.addAll(entries);
        Crosstab<Serializable> crosstab = PatternFinderAnalyzer.createCrosstab();
        for (Map.Entry entry : sortedEntrySet) {
            CrosstabNavigator nav = crosstab.navigate();
            TokenPattern pattern = (TokenPattern)entry.getKey();
            nav.where("Pattern", pattern.toSymbolicString());
            nav.where("Measures", "Match count");
            AtomicInteger count = (AtomicInteger)entry.getValue();
            nav.put((Serializable)count, true);
            nav.where("Measures", "Sample");
            sample = patternFinder.getSample(pattern);
            nav.put((Serializable)((Object)sample), true);
        }
        return crosstab;
    }
}

