/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.stringpattern;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class PredefinedTokenDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _name;
    private Set<String> _tokenRegexes;
    private Set<Pattern> _tokenRegexPatterns;

    public PredefinedTokenDefinition(String name, Set<String> tokenRegexes) {
        this._name = name;
        this._tokenRegexes = tokenRegexes;
    }

    public PredefinedTokenDefinition(String name, String ... tokenRegexes) {
        this._name = name;
        this._tokenRegexes = new LinkedHashSet<String>();
        for (String string : tokenRegexes) {
            this._tokenRegexes.add(string);
        }
    }

    public String getName() {
        return this._name;
    }

    public Set<String> getTokenRegexes() {
        return Collections.unmodifiableSet(this._tokenRegexes);
    }

    public Set<Pattern> getTokenRegexPatterns() {
        if (this._tokenRegexPatterns == null) {
            this._tokenRegexPatterns = new LinkedHashSet<Pattern>();
            for (String tokenRegex : this._tokenRegexes) {
                Pattern pattern = Pattern.compile(tokenRegex);
                this._tokenRegexPatterns.add(pattern);
            }
        }
        return this._tokenRegexPatterns;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PredefinedTokenDefinition other = (PredefinedTokenDefinition)obj;
        return !(this._name == null ? other._name != null : !this._name.equals(other._name));
    }

    public String toString() {
        return "PredefinedToken[name=" + this._name + "]";
    }
}

