/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.stringpattern;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eobjects.analyzer.beans.stringpattern.PredefinedToken;
import org.eobjects.analyzer.beans.stringpattern.PredefinedTokenDefinition;
import org.eobjects.analyzer.beans.stringpattern.Token;
import org.eobjects.analyzer.beans.stringpattern.Tokenizer;
import org.eobjects.analyzer.beans.stringpattern.UndefinedToken;

public class PredefinedTokenTokenizer
implements Tokenizer {
    private List<PredefinedTokenDefinition> _predefinedTokenDefitions;

    public PredefinedTokenTokenizer(PredefinedTokenDefinition ... predefinedTokenDefinitions) {
        this._predefinedTokenDefitions = new LinkedList<PredefinedTokenDefinition>();
        for (PredefinedTokenDefinition predefinedToken : predefinedTokenDefinitions) {
            this._predefinedTokenDefitions.add(predefinedToken);
        }
    }

    public PredefinedTokenTokenizer(List<PredefinedTokenDefinition> predefinedTokenDefinitions) {
        this._predefinedTokenDefitions = predefinedTokenDefinitions;
    }

    @Override
    public List<Token> tokenize(String s) {
        ArrayList<Token> result = new ArrayList<Token>();
        result.add(new UndefinedToken(s));
        for (PredefinedTokenDefinition predefinedTokenDefinition : this._predefinedTokenDefitions) {
            Set<Pattern> patterns = predefinedTokenDefinition.getTokenRegexPatterns();
            for (Pattern pattern : patterns) {
                ListIterator<Token> it = result.listIterator();
                while (it.hasNext()) {
                    List<Token> replacementTokens;
                    Token token = (Token)it.next();
                    if (!(token instanceof UndefinedToken) || (replacementTokens = PredefinedTokenTokenizer.tokenizeInternal(token.getString(), predefinedTokenDefinition, pattern)).size() <= 1) continue;
                    it.remove();
                    for (Token newToken : replacementTokens) {
                        it.add(newToken);
                    }
                }
            }
        }
        return result;
    }

    protected static List<Token> tokenizeInternal(String string, PredefinedTokenDefinition predefinedTokenDefinition, Pattern pattern) {
        LinkedList<Token> result = new LinkedList<Token>();
        result.add(new UndefinedToken(string));
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            result.removeLast();
            if (start > 0) {
                result.add(new UndefinedToken(string.substring(0, start)));
            }
            result.add(new PredefinedToken(predefinedTokenDefinition, string.substring(start, end)));
            if (end == string.length()) break;
            string = string.substring(end);
            result.add(new UndefinedToken(string));
            matcher = pattern.matcher(string);
        }
        return result;
    }
}

