/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.stringpattern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eobjects.analyzer.beans.stringpattern.Token;
import org.eobjects.analyzer.beans.stringpattern.TokenPattern;
import org.eobjects.analyzer.beans.stringpattern.TokenPatternSymbol;
import org.eobjects.analyzer.beans.stringpattern.TokenPatternSymbolImpl;
import org.eobjects.analyzer.beans.stringpattern.TokenizerConfiguration;

public final class TokenPatternImpl
implements TokenPattern {
    private static final long serialVersionUID = 1L;
    private final TokenizerConfiguration _configuration;
    private final List<TokenPatternSymbol> _symbols;
    private final String _sampleString;

    public TokenPatternImpl(String sampleString, List<Token> tokens, TokenizerConfiguration configuration) {
        if (tokens == null) {
            throw new IllegalArgumentException("tokens cannot be null");
        }
        this._symbols = new ArrayList<TokenPatternSymbol>(tokens.size());
        for (Token token : tokens) {
            this._symbols.add(new TokenPatternSymbolImpl(token, configuration));
        }
        this._configuration = configuration;
        this._sampleString = sampleString;
    }

    @Override
    public boolean match(List<Token> tokens) {
        TokenPatternSymbol tokenSymbol;
        if (this._symbols.size() != tokens.size()) {
            return false;
        }
        Iterator<TokenPatternSymbol> it1 = this._symbols.iterator();
        Iterator<Token> it2 = tokens.iterator();
        while (it1.hasNext()) {
            Token token;
            tokenSymbol = it1.next();
            if (tokenSymbol.matches(token = it2.next(), this._configuration)) continue;
            return false;
        }
        it1 = this._symbols.iterator();
        it2 = tokens.iterator();
        while (it1.hasNext()) {
            int length2;
            int length1;
            tokenSymbol = it1.next();
            Token token2 = it2.next();
            if (!tokenSymbol.isExpandable() || (length1 = tokenSymbol.length()) >= (length2 = token2.length())) continue;
            int diff = length2 - length1;
            tokenSymbol.expandLenght(diff);
        }
        return true;
    }

    @Override
    public List<TokenPatternSymbol> getSymbols() {
        return Collections.unmodifiableList(this._symbols);
    }

    @Override
    public String toSymbolicString() {
        StringBuilder sb = new StringBuilder();
        for (TokenPatternSymbol symbol : this._symbols) {
            sb.append(symbol.toSymbolicString());
        }
        return sb.toString();
    }

    @Override
    public String getSampleString() {
        return this._sampleString;
    }
}

