/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.reference;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import org.eobjects.analyzer.beans.stringpattern.DefaultTokenizer;
import org.eobjects.analyzer.beans.stringpattern.Token;
import org.eobjects.analyzer.beans.stringpattern.TokenPattern;
import org.eobjects.analyzer.beans.stringpattern.TokenPatternImpl;
import org.eobjects.analyzer.beans.stringpattern.Tokenizer;
import org.eobjects.analyzer.beans.stringpattern.TokenizerConfiguration;
import org.eobjects.analyzer.reference.AbstractReferenceData;
import org.eobjects.analyzer.reference.StringPattern;
import org.eobjects.analyzer.util.ReadObjectBuilder;

public final class SimpleStringPattern
extends AbstractReferenceData
implements StringPattern {
    private static final long serialVersionUID = 1L;
    private final String _expression;
    private transient TokenPattern _tokenPattern;
    private transient DefaultTokenizer _tokenizer;
    private transient TokenizerConfiguration _configuration;

    public SimpleStringPattern(String name, String expression) {
        this(name, expression, new TokenizerConfiguration());
    }

    public SimpleStringPattern(String name, String expression, TokenizerConfiguration configuration) {
        super(name);
        this._expression = expression;
        this._configuration = configuration;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create((Serializable)((Object)this), SimpleStringPattern.class).readObject(stream);
    }

    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._expression);
    }

    private Tokenizer getTokenizer() {
        if (this._tokenizer == null) {
            this._tokenizer = new DefaultTokenizer(this.getConfiguration());
        }
        return this._tokenizer;
    }

    private TokenizerConfiguration getConfiguration() {
        if (this._configuration == null) {
            this._configuration = new TokenizerConfiguration();
        }
        return this._configuration;
    }

    private TokenPattern getTokenPattern() {
        if (this._tokenPattern == null) {
            String expression = "<null>".equals(this._expression) ? null : ("<blank>".equals(this._expression) ? "" : this._expression);
            List<Token> tokens = this.getTokenizer().tokenize(expression);
            this._tokenPattern = new TokenPatternImpl(expression, tokens, this.getConfiguration());
        }
        return this._tokenPattern;
    }

    public String getExpression() {
        return this._expression;
    }

    public boolean matches(String string) {
        List<Token> tokens = this.getTokenizer().tokenize(string);
        return this.getTokenPattern().match(tokens);
    }

    public String toString() {
        return "SimpleStringPattern[name=" + this.getName() + ", expression=" + this._expression + "]";
    }
}

